/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.guava.FunctionalIterable;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.data.Indexed;
import javax.annotation.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptFilter
implements Filter {
    private final JavaScriptPredicate predicate;
    private final String dimension;

    public JavaScriptFilter(String dimension, String script) {
        this.dimension = dimension;
        this.predicate = new JavaScriptPredicate(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBitmap getBitmapIndex(final BitmapIndexSelector selector) {
        final Context cx = Context.enter();
        try {
            Indexed<String> dimValues = selector.getDimensionValues(this.dimension);
            ImmutableBitmap bitmap = dimValues == null ? selector.getBitmapFactory().makeEmptyImmutableBitmap() : selector.getBitmapFactory().union((Iterable)FunctionalIterable.create(dimValues).filter((Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return JavaScriptFilter.this.predicate.applyInContext(cx, input);
                }
            }).transform((Function)new Function<String, ImmutableBitmap>(){

                public ImmutableBitmap apply(@Nullable String input) {
                    return selector.getBitmapIndex(JavaScriptFilter.this.dimension, input);
                }
            }));
            ImmutableBitmap immutableBitmap = bitmap;
            return immutableBitmap;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicate);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        throw new UnsupportedOperationException();
    }

    static class JavaScriptPredicate
    implements Predicate<String> {
        final ScriptableObject scope;
        final org.mozilla.javascript.Function fnApply;
        final String script;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaScriptPredicate(String script) {
            Preconditions.checkNotNull((Object)script, (Object)"script must not be null");
            this.script = script;
            Context cx = Context.enter();
            try {
                cx.setOptimizationLevel(9);
                this.scope = cx.initStandardObjects();
                this.fnApply = cx.compileFunction((Scriptable)this.scope, script, "script", 1, null);
            }
            finally {
                Context.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(String input) {
            Context cx = Context.enter();
            try {
                boolean bl = this.applyInContext(cx, input);
                return bl;
            }
            finally {
                Context.exit();
            }
        }

        public boolean applyInContext(Context cx, String input) {
            return Context.toBoolean((Object)this.fnApply.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])new String[]{input}));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaScriptPredicate that = (JavaScriptPredicate)o;
            return this.script.equals(that.script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }
}

