/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.Offset;

public class StartLimitedOffset
implements Offset {
    private final Offset baseOffset;
    private final int limit;

    public StartLimitedOffset(Offset baseOffset, int limit) {
        this.baseOffset = baseOffset;
        this.limit = limit;
        while (baseOffset.withinBounds() && baseOffset.getOffset() < limit) {
            baseOffset.increment();
        }
    }

    @Override
    public void increment() {
        this.baseOffset.increment();
    }

    @Override
    public boolean withinBounds() {
        return this.baseOffset.withinBounds();
    }

    @Override
    public Offset clone() {
        return new StartLimitedOffset(this.baseOffset.clone(), this.limit);
    }

    @Override
    public int getOffset() {
        return this.baseOffset.getOffset();
    }
}

