/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.guava.CloseQuietly;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedFloatBufferObjectStrategy;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedFloats;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;

public class InMemoryCompressedFloats
implements IndexedFloats {
    public static final CompressedObjectStrategy.CompressionStrategy COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY;
    private final CompressedFloatBufferObjectStrategy strategy;
    private final int sizePer;
    private List<byte[]> compressedBuffers = Lists.newArrayList();
    private int numInserted = 0;
    private int numCompressed = 0;
    private ResourceHolder<FloatBuffer> holder = null;
    private FloatBuffer loadBuffer = null;
    private int loadBufferIndex = -1;
    private FloatBuffer endBuffer;

    public InMemoryCompressedFloats(int sizePer, ByteOrder order) {
        this.sizePer = sizePer;
        this.strategy = CompressedFloatBufferObjectStrategy.getBufferForOrder(order, COMPRESSION, sizePer);
        this.endBuffer = FloatBuffer.allocate(sizePer);
        this.endBuffer.mark();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    public int add(float value) {
        int retVal = -1;
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.compressedBuffers.add(this.strategy.toBytes(StupidResourceHolder.create((Object)this.endBuffer)));
            this.endBuffer = FloatBuffer.allocate(this.sizePer);
            this.endBuffer.mark();
            this.numCompressed += this.sizePer;
        }
        retVal = this.numCompressed + this.endBuffer.position();
        this.endBuffer.put(value);
        ++this.numInserted;
        return retVal;
    }

    public int addAll(Iterable<Float> values) {
        int retVal = -1;
        for (Float value : values) {
            retVal = this.add(value.floatValue());
        }
        return retVal;
    }

    @Override
    public float get(int index) {
        int bufferNum = index / this.sizePer;
        int bufferIndex = index % this.sizePer;
        if (bufferNum == this.compressedBuffers.size()) {
            return this.endBuffer.get(bufferIndex);
        }
        if (bufferNum != this.loadBufferIndex) {
            this.loadBuffer(bufferNum);
        }
        return this.loadBuffer.get(this.loadBuffer.position() + bufferIndex);
    }

    @Override
    public void fill(int index, float[] toFill) {
        if (this.size() - index < toFill.length) {
            throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, this.size()));
        }
        int bufferNum = index / this.sizePer;
        int bufferIndex = index % this.sizePer;
        int leftToFill = toFill.length;
        while (leftToFill > 0) {
            if (bufferNum == this.compressedBuffers.size()) {
                this.endBuffer.mark();
                this.endBuffer.position(bufferIndex);
                this.endBuffer.get(toFill, toFill.length - leftToFill, leftToFill);
                this.endBuffer.rewind();
                return;
            }
            if (bufferNum != this.loadBufferIndex) {
                this.loadBuffer(bufferNum);
            }
            this.loadBuffer.mark();
            this.loadBuffer.position(this.loadBuffer.position() + bufferIndex);
            int numToGet = Math.min(this.loadBuffer.remaining(), leftToFill);
            this.loadBuffer.get(toFill, toFill.length - leftToFill, numToGet);
            this.loadBuffer.rewind();
            leftToFill -= numToGet;
            ++bufferNum;
            bufferIndex = 0;
        }
    }

    private void loadBuffer(int bufferNum) {
        this.loadBuffer = null;
        CloseQuietly.close(this.holder);
        byte[] compressedBytes = this.compressedBuffers.get(bufferNum);
        this.holder = this.strategy.fromByteBuffer(ByteBuffer.wrap(compressedBytes), compressedBytes.length);
        this.loadBuffer = (FloatBuffer)this.holder.get();
        this.loadBufferIndex = bufferNum;
    }

    public CompressedFloatsIndexedSupplier toCompressedFloatsIndexedSupplier() {
        FloatBuffer endBufCopy = this.endBuffer.asReadOnlyBuffer();
        endBufCopy.flip();
        return new CompressedFloatsIndexedSupplier(this.numInserted, this.sizePer, GenericIndexed.fromIterable(Iterables.concat((Iterable)Iterables.transform(this.compressedBuffers, (Function)new Function<byte[], ResourceHolder<FloatBuffer>>(){

            public ResourceHolder<FloatBuffer> apply(byte[] input) {
                return InMemoryCompressedFloats.this.strategy.fromByteBuffer(ByteBuffer.wrap(input), input.length);
            }
        }), Arrays.asList(StupidResourceHolder.create((Object)endBufCopy))), this.strategy), COMPRESSION);
    }

    @Override
    public void close() throws IOException {
        CloseQuietly.close(this.holder);
    }
}

