/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import com.metamx.common.guava.CloseQuietly;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedIntBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIntsIterator;
import io.druid.segment.data.WritableSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import java.util.List;

public class CompressedIntsIndexedSupplier
implements WritableSupplier<IndexedInts> {
    public static final byte version = 2;
    public static final int MAX_INTS_IN_BUFFER = 16384;
    private final int totalSize;
    private final int sizePer;
    private final GenericIndexed<ResourceHolder<IntBuffer>> baseIntBuffers;
    private final CompressedObjectStrategy.CompressionStrategy compression;

    CompressedIntsIndexedSupplier(int totalSize, int sizePer, GenericIndexed<ResourceHolder<IntBuffer>> baseIntBuffers, CompressedObjectStrategy.CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseIntBuffers = baseIntBuffers;
        this.compression = compression;
    }

    public int size() {
        return this.totalSize;
    }

    public IndexedInts get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            return new CompressedIndexedInts(){

                @Override
                public int get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.buffer.get(this.buffer.position() + bufferIndex);
                }
            };
        }
        return new CompressedIndexedInts();
    }

    @Override
    public long getSerializedSize() {
        return 10L + this.baseIntBuffers.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        this.baseIntBuffers.writeToChannel(channel);
    }

    public CompressedIntsIndexedSupplier convertByteOrder(ByteOrder order) {
        return new CompressedIntsIndexedSupplier(this.totalSize, this.sizePer, GenericIndexed.fromIterable(this.baseIntBuffers, CompressedIntBufferObjectStrategy.getBufferForOrder(order, this.compression, this.sizePer)), this.compression);
    }

    GenericIndexed<ResourceHolder<IntBuffer>> getBaseIntBuffers() {
        return this.baseIntBuffers;
    }

    public static CompressedIntsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.forId(buffer.get());
            return new CompressedIntsIndexedSupplier(totalSize, sizePer, GenericIndexed.read(buffer, CompressedIntBufferObjectStrategy.getBufferForOrder(order, compression, sizePer)), compression);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    public static CompressedIntsIndexedSupplier fromIntBuffer(IntBuffer buffer, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        return CompressedIntsIndexedSupplier.fromIntBuffer(buffer, 16384, byteOrder, compression);
    }

    public static CompressedIntsIndexedSupplier fromIntBuffer(final IntBuffer buffer, final int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        Preconditions.checkArgument((chunkFactor <= 16384 ? 1 : 0) != 0, (String)"Chunks must be <= 64k bytes. chunkFactor was[%s]", (Object[])new Object[]{chunkFactor});
        return new CompressedIntsIndexedSupplier(buffer.remaining(), chunkFactor, GenericIndexed.fromIterable(new Iterable<ResourceHolder<IntBuffer>>(){

            @Override
            public Iterator<ResourceHolder<IntBuffer>> iterator() {
                return new Iterator<ResourceHolder<IntBuffer>>(){
                    IntBuffer myBuffer;
                    {
                        this.myBuffer = buffer.asReadOnlyBuffer();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myBuffer.hasRemaining();
                    }

                    @Override
                    public ResourceHolder<IntBuffer> next() {
                        IntBuffer retVal = this.myBuffer.asReadOnlyBuffer();
                        if (chunkFactor < this.myBuffer.remaining()) {
                            retVal.limit(retVal.position() + chunkFactor);
                        }
                        this.myBuffer.position(this.myBuffer.position() + retVal.remaining());
                        return StupidResourceHolder.create((Object)retVal);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, CompressedIntBufferObjectStrategy.getBufferForOrder(byteOrder, compression, chunkFactor)), compression);
    }

    public static CompressedIntsIndexedSupplier fromList(final List<Integer> list, final int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        Preconditions.checkArgument((chunkFactor <= 16384 ? 1 : 0) != 0, (String)"Chunks must be <= 64k bytes. chunkFactor was[%s]", (Object[])new Object[]{chunkFactor});
        return new CompressedIntsIndexedSupplier(list.size(), chunkFactor, GenericIndexed.fromIterable(new Iterable<ResourceHolder<IntBuffer>>(){

            @Override
            public Iterator<ResourceHolder<IntBuffer>> iterator() {
                return new Iterator<ResourceHolder<IntBuffer>>(){
                    int position = 0;

                    @Override
                    public boolean hasNext() {
                        return this.position < list.size();
                    }

                    @Override
                    public ResourceHolder<IntBuffer> next() {
                        IntBuffer retVal = IntBuffer.allocate(chunkFactor);
                        if (chunkFactor > list.size() - this.position) {
                            retVal.limit(list.size() - this.position);
                        }
                        List ints = list.subList(this.position, this.position + retVal.remaining());
                        Iterator i$ = ints.iterator();
                        while (i$.hasNext()) {
                            int value = (Integer)i$.next();
                            retVal.put(value);
                        }
                        retVal.rewind();
                        this.position += retVal.remaining();
                        return StupidResourceHolder.create((Object)retVal);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, CompressedIntBufferObjectStrategy.getBufferForOrder(byteOrder, compression, chunkFactor)), compression);
    }

    private class CompressedIndexedInts
    implements IndexedInts {
        final Indexed<ResourceHolder<IntBuffer>> singleThreadedIntBuffers;
        int currIndex;
        ResourceHolder<IntBuffer> holder;
        IntBuffer buffer;

        private CompressedIndexedInts() {
            this.singleThreadedIntBuffers = CompressedIntsIndexedSupplier.this.baseIntBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return CompressedIntsIndexedSupplier.this.totalSize;
        }

        @Override
        public int get(int index) {
            int bufferNum = index / CompressedIntsIndexedSupplier.this.sizePer;
            int bufferIndex = index % CompressedIntsIndexedSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.buffer.get(this.buffer.position() + bufferIndex);
        }

        @Override
        public Iterator<Integer> iterator() {
            return new IndexedIntsIterator(this);
        }

        @Override
        public void fill(int index, int[] toFill) {
            if (CompressedIntsIndexedSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, CompressedIntsIndexedSupplier.this.totalSize));
            }
            int bufferNum = index / CompressedIntsIndexedSupplier.this.sizePer;
            int bufferIndex = index % CompressedIntsIndexedSupplier.this.sizePer;
            int leftToFill = toFill.length;
            while (leftToFill > 0) {
                if (bufferNum != this.currIndex) {
                    this.loadBuffer(bufferNum);
                }
                this.buffer.mark();
                this.buffer.position(this.buffer.position() + bufferIndex);
                int numToGet = Math.min(this.buffer.remaining(), leftToFill);
                this.buffer.get(toFill, toFill.length - leftToFill, numToGet);
                this.buffer.reset();
                leftToFill -= numToGet;
                ++bufferNum;
                bufferIndex = 0;
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedIntBuffers.get(bufferNum);
            this.buffer = (IntBuffer)this.holder.get();
            this.currIndex = bufferNum;
        }

        public String toString() {
            return "CompressedIntsIndexedSupplier_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + CompressedIntsIndexedSupplier.this.sizePer + ", numChunks=" + this.singleThreadedIntBuffers.size() + ", totalSize=" + CompressedIntsIndexedSupplier.this.totalSize + '}';
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.holder, (boolean)false);
        }
    }
}

