/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedFloatBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class CompressedFloatsSupplierSerializer {
    private final int sizePer;
    private final GenericIndexedWriter<ResourceHolder<FloatBuffer>> flattener;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private int numInserted = 0;
    private FloatBuffer endBuffer;

    public static CompressedFloatsSupplierSerializer create(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) throws IOException {
        return CompressedFloatsSupplierSerializer.create(ioPeon, filenameBase, 16384, order, compression);
    }

    public static CompressedFloatsSupplierSerializer create(IOPeon ioPeon, String filenameBase, int sizePer, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) throws IOException {
        CompressedFloatsSupplierSerializer retVal = new CompressedFloatsSupplierSerializer(sizePer, new GenericIndexedWriter<ResourceHolder<FloatBuffer>>(ioPeon, filenameBase, CompressedFloatBufferObjectStrategy.getBufferForOrder(order, compression, sizePer)), compression);
        return retVal;
    }

    public CompressedFloatsSupplierSerializer(int sizePer, GenericIndexedWriter<ResourceHolder<FloatBuffer>> flattener, CompressedObjectStrategy.CompressionStrategy compression) {
        this.sizePer = sizePer;
        this.flattener = flattener;
        this.compression = compression;
        this.endBuffer = FloatBuffer.allocate(sizePer);
        this.endBuffer.mark();
    }

    public void open() throws IOException {
        this.flattener.open();
    }

    public int size() {
        return this.numInserted;
    }

    public void add(float value) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<FloatBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            this.endBuffer = FloatBuffer.allocate(this.sizePer);
            this.endBuffer.mark();
        }
        this.endBuffer.put(value);
        ++this.numInserted;
    }

    public void closeAndConsolidate(OutputSupplier<? extends OutputStream> consolidatedOut) throws IOException {
        this.endBuffer.limit(this.endBuffer.position());
        this.endBuffer.rewind();
        this.flattener.write((ResourceHolder<FloatBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
        this.endBuffer = null;
        this.flattener.close();
        try (OutputStream out = (OutputStream)consolidatedOut.getOutput();){
            out.write(2);
            out.write(Ints.toByteArray((int)this.numInserted));
            out.write(Ints.toByteArray((int)this.sizePer));
            out.write(new byte[]{this.compression.getId()});
            ByteStreams.copy(this.flattener.combineStreams(), (OutputStream)out);
        }
    }
}

