/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import com.metamx.common.guava.CloseQuietly;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedFloatBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedFloats;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

public class CompressedFloatsIndexedSupplier
implements Supplier<IndexedFloats> {
    public static final byte LZF_VERSION = 1;
    public static final byte version = 2;
    public static final int MAX_FLOATS_IN_BUFFER = 16384;
    private final int totalSize;
    private final int sizePer;
    private final GenericIndexed<ResourceHolder<FloatBuffer>> baseFloatBuffers;
    private final CompressedObjectStrategy.CompressionStrategy compression;

    CompressedFloatsIndexedSupplier(int totalSize, int sizePer, GenericIndexed<ResourceHolder<FloatBuffer>> baseFloatBuffers, CompressedObjectStrategy.CompressionStrategy compression) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseFloatBuffers = baseFloatBuffers;
        this.compression = compression;
    }

    public int size() {
        return this.totalSize;
    }

    public IndexedFloats get() {
        boolean powerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = powerOf2 = this.sizePer == 1 << div;
        if (powerOf2) {
            return new CompressedIndexedFloats(){

                @Override
                public float get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currIndex) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.buffer.get(this.buffer.position() + bufferIndex);
                }
            };
        }
        return new CompressedIndexedFloats();
    }

    public long getSerializedSize() {
        return this.baseFloatBuffers.getSerializedSize() + 1L + 4L + 4L + 1L;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        this.baseFloatBuffers.writeToChannel(channel);
    }

    public CompressedFloatsIndexedSupplier convertByteOrder(ByteOrder order) {
        return new CompressedFloatsIndexedSupplier(this.totalSize, this.sizePer, GenericIndexed.fromIterable(this.baseFloatBuffers, CompressedFloatBufferObjectStrategy.getBufferForOrder(order, this.compression, this.sizePer)), this.compression);
    }

    GenericIndexed<ResourceHolder<FloatBuffer>> getBaseFloatBuffers() {
        return this.baseFloatBuffers;
    }

    public static CompressedFloatsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.forId(buffer.get());
            return new CompressedFloatsIndexedSupplier(totalSize, sizePer, GenericIndexed.read(buffer, CompressedFloatBufferObjectStrategy.getBufferForOrder(order, compression, sizePer)), compression);
        }
        if (versionFromBuffer == 1) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.LZF;
            return new CompressedFloatsIndexedSupplier(totalSize, sizePer, GenericIndexed.read(buffer, CompressedFloatBufferObjectStrategy.getBufferForOrder(order, compression, sizePer)), compression);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    public static CompressedFloatsIndexedSupplier fromFloatBuffer(FloatBuffer buffer, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) {
        return CompressedFloatsIndexedSupplier.fromFloatBuffer(buffer, 16384, order, compression);
    }

    public static CompressedFloatsIndexedSupplier fromFloatBuffer(final FloatBuffer buffer, final int chunkFactor, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) {
        Preconditions.checkArgument((chunkFactor <= 16384 ? 1 : 0) != 0, (String)"Chunks must be <= 64k bytes. chunkFactor was[%s]", (Object[])new Object[]{chunkFactor});
        return new CompressedFloatsIndexedSupplier(buffer.remaining(), chunkFactor, GenericIndexed.fromIterable(new Iterable<ResourceHolder<FloatBuffer>>(){

            @Override
            public Iterator<ResourceHolder<FloatBuffer>> iterator() {
                return new Iterator<ResourceHolder<FloatBuffer>>(){
                    FloatBuffer myBuffer;
                    {
                        this.myBuffer = buffer.asReadOnlyBuffer();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myBuffer.hasRemaining();
                    }

                    @Override
                    public ResourceHolder<FloatBuffer> next() {
                        FloatBuffer retVal = this.myBuffer.asReadOnlyBuffer();
                        if (chunkFactor < this.myBuffer.remaining()) {
                            retVal.limit(retVal.position() + chunkFactor);
                        }
                        this.myBuffer.position(this.myBuffer.position() + retVal.remaining());
                        return StupidResourceHolder.create((Object)retVal);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, CompressedFloatBufferObjectStrategy.getBufferForOrder(order, compression, chunkFactor)), compression);
    }

    private class CompressedIndexedFloats
    implements IndexedFloats {
        final Indexed<ResourceHolder<FloatBuffer>> singleThreadedFloatBuffers;
        int currIndex;
        ResourceHolder<FloatBuffer> holder;
        FloatBuffer buffer;

        private CompressedIndexedFloats() {
            this.singleThreadedFloatBuffers = CompressedFloatsIndexedSupplier.this.baseFloatBuffers.singleThreaded();
            this.currIndex = -1;
        }

        @Override
        public int size() {
            return CompressedFloatsIndexedSupplier.this.totalSize;
        }

        @Override
        public float get(int index) {
            int bufferNum = index / CompressedFloatsIndexedSupplier.this.sizePer;
            int bufferIndex = index % CompressedFloatsIndexedSupplier.this.sizePer;
            if (bufferNum != this.currIndex) {
                this.loadBuffer(bufferNum);
            }
            return this.buffer.get(this.buffer.position() + bufferIndex);
        }

        @Override
        public void fill(int index, float[] toFill) {
            if (CompressedFloatsIndexedSupplier.this.totalSize - index < toFill.length) {
                throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, CompressedFloatsIndexedSupplier.this.totalSize));
            }
            int bufferNum = index / CompressedFloatsIndexedSupplier.this.sizePer;
            int bufferIndex = index % CompressedFloatsIndexedSupplier.this.sizePer;
            int leftToFill = toFill.length;
            while (leftToFill > 0) {
                if (bufferNum != this.currIndex) {
                    this.loadBuffer(bufferNum);
                }
                this.buffer.mark();
                this.buffer.position(this.buffer.position() + bufferIndex);
                int numToGet = Math.min(this.buffer.remaining(), leftToFill);
                this.buffer.get(toFill, toFill.length - leftToFill, numToGet);
                this.buffer.reset();
                leftToFill -= numToGet;
                ++bufferNum;
                bufferIndex = 0;
            }
        }

        protected void loadBuffer(int bufferNum) {
            CloseQuietly.close(this.holder);
            this.holder = this.singleThreadedFloatBuffers.get(bufferNum);
            this.buffer = (FloatBuffer)this.holder.get();
            this.currIndex = bufferNum;
        }

        public String toString() {
            return "CompressedFloatsIndexedSupplier_Anonymous{currIndex=" + this.currIndex + ", sizePer=" + CompressedFloatsIndexedSupplier.this.sizePer + ", numChunks=" + this.singleThreadedFloatBuffers.size() + ", totalSize=" + CompressedFloatsIndexedSupplier.this.totalSize + '}';
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.holder, (boolean)false);
        }
    }
}

