/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.InputSupplier;
import com.google.common.primitives.Ints;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.ObjectStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ByteBufferWriter<T>
implements Closeable {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy<T> strategy;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valueOut = null;

    public ByteBufferWriter(IOPeon ioPeon, String filenameBase, ObjectStrategy<T> strategy) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("header")));
        this.valueOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("value")));
    }

    public void write(T objectToWrite) throws IOException {
        byte[] bytesToWrite = this.strategy.toBytes(objectToWrite);
        this.headerOut.write(Ints.toByteArray((int)bytesToWrite.length));
        this.valueOut.write(bytesToWrite);
    }

    private String makeFilename(String suffix) {
        return String.format("%s.%s", this.filenameBase, suffix);
    }

    @Override
    public void close() throws IOException {
        this.headerOut.close();
        this.valueOut.close();
        long numBytesWritten = this.headerOut.getCount() + this.valueOut.getCount();
        Preconditions.checkState((numBytesWritten < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Wrote[%s] bytes, which is too many.", (Object[])new Object[]{numBytesWritten});
    }

    public InputSupplier<InputStream> combineStreams() {
        return ByteStreams.join((Iterable)Iterables.transform(Arrays.asList("header", "value"), (Function)new Function<String, InputSupplier<InputStream>>(){

            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return ByteBufferWriter.this.ioPeon.makeInputStream(ByteBufferWriter.this.makeFilename(input));
                    }
                };
            }
        }));
    }
}

