/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.DimensionSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.data.IndexedInts;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class SingleScanTimeDimSelector
implements DimensionSelector {
    private final ExtractionFn extractionFn;
    private final LongColumnSelector selector;
    private final Map<Integer, String> timeValues = Maps.newHashMap();
    private String currentValue = null;
    private long currentTimestamp = Long.MIN_VALUE;
    private int index = -1;

    public SingleScanTimeDimSelector(LongColumnSelector selector, ExtractionFn extractionFn) {
        if (extractionFn == null) {
            throw new UnsupportedOperationException("time dimension must provide an extraction function");
        }
        this.extractionFn = extractionFn;
        this.selector = selector;
    }

    @Override
    public IndexedInts getRow() {
        long timestamp = this.selector.get();
        if (this.index < 0) {
            this.currentTimestamp = timestamp;
            this.currentValue = this.extractionFn.apply(timestamp);
            ++this.index;
            this.timeValues.put(this.index, this.currentValue);
        } else if (timestamp != this.currentTimestamp) {
            if (timestamp < this.currentTimestamp) {
                throw new IllegalStateException("cannot re-use time dimension selector for multiple scans");
            }
            this.currentTimestamp = timestamp;
            String value = this.extractionFn.apply(timestamp);
            if (!value.equals(this.currentValue)) {
                this.currentValue = value;
                ++this.index;
                this.timeValues.put(this.index, this.currentValue);
            }
        }
        final int dimensionValueIndex = this.index;
        return new IndexedInts(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public int get(int i) {
                return dimensionValueIndex;
            }

            @Override
            public Iterator<Integer> iterator() {
                return Iterators.singletonIterator((Object)dimensionValueIndex);
            }

            @Override
            public void fill(int index, int[] toFill) {
                throw new UnsupportedOperationException("fill not supported");
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public int getValueCardinality() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String lookupName(int id) {
        if (id == this.index) {
            return this.currentValue;
        }
        return this.timeValues.get(id);
    }

    @Override
    public int lookupId(String name) {
        throw new UnsupportedOperationException("time column does not support lookups");
    }
}

