/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.emitter.EmittingLogger;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.Interval;

public class ReferenceCountingSegment
implements Segment {
    private static final EmittingLogger log = new EmittingLogger(ReferenceCountingSegment.class);
    private final Segment baseSegment;
    private final Object lock = new Object();
    private volatile int numReferences = 0;
    private volatile boolean isClosed = false;

    public ReferenceCountingSegment(Segment baseSegment) {
        this.baseSegment = baseSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getBaseSegment() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return null;
            }
            return this.baseSegment;
        }
    }

    public int getNumReferences() {
        return this.numReferences;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIdentifier() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return null;
            }
            return this.baseSegment.getIdentifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interval getDataInterval() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return null;
            }
            return this.baseSegment.getDataInterval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryableIndex asQueryableIndex() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return null;
            }
            return this.baseSegment.asQueryableIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageAdapter asStorageAdapter() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return null;
            }
            return this.baseSegment.asStorageAdapter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                log.info("Failed to close, %s is closed already", new Object[]{this.baseSegment.getIdentifier()});
                return;
            }
            if (this.numReferences > 0) {
                log.info("%d references to %s still exist. Decrementing.", new Object[]{this.numReferences, this.baseSegment.getIdentifier()});
                this.decrement();
            } else {
                log.info("Closing %s", new Object[]{this.baseSegment.getIdentifier()});
                this.innerClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Closeable increment() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return null;
            }
            ++this.numReferences;
            final AtomicBoolean decrementOnce = new AtomicBoolean(false);
            return new Closeable(){

                @Override
                public void close() throws IOException {
                    if (decrementOnce.compareAndSet(false, true)) {
                        ReferenceCountingSegment.this.decrement();
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            if (--this.numReferences < 0) {
                try {
                    this.innerClose();
                }
                catch (Exception e) {
                    log.error("Unable to close queryable index %s", new Object[]{this.getIdentifier()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            log.info("Closing %s, numReferences: %d", new Object[]{this.baseSegment.getIdentifier(), this.numReferences});
            this.isClosed = true;
            this.baseSegment.close();
        }
    }
}

