/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.granularity.QueryGranularity;
import io.druid.query.QueryInterruptedException;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.Filter;
import io.druid.segment.BitmapOffset;
import io.druid.segment.Capabilities;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.NullDimensionSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.SingleScanTimeDimSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.Offset;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    private static final NullDimensionSelector NULL_DIMENSION_SELECTOR = new NullDimensionSelector();
    private final QueryableIndex index;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return Sets.difference((Set)Sets.newHashSet(this.index.getColumnNames()), (Set)Sets.newHashSet(this.index.getAvailableDimensions()));
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension == null) {
            return 0;
        }
        Column column = this.index.getColumn(dimension);
        if (column == null) {
            return 0;
        }
        if (!column.getCapabilities().isDictionaryEncoded()) {
            return Integer.MAX_VALUE;
        }
        return column.getDictionaryEncoding().getCardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getMinTime() {
        DateTime dateTime;
        GenericColumn column = null;
        try {
            column = this.index.getColumn("__time").getGenericColumn();
            dateTime = new DateTime(column.getLongSingleValueRow(0));
        }
        catch (Throwable throwable) {
            CloseQuietly.close(column);
            throw throwable;
        }
        CloseQuietly.close((Closeable)column);
        return dateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateTime getMaxTime() {
        DateTime dateTime;
        GenericColumn column = null;
        try {
            column = this.index.getColumn("__time").getGenericColumn();
            dateTime = new DateTime(column.getLongSingleValueRow(column.length() - 1));
        }
        catch (Throwable throwable) {
            CloseQuietly.close(column);
            throw throwable;
        }
        CloseQuietly.close((Closeable)column);
        return dateTime;
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(true).build();
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(Filter filter, Interval interval, QueryGranularity gran) {
        Offset offset;
        Interval actualInterval = interval;
        Interval dataInterval = new Interval(this.getMinTime().getMillis(), gran.next(gran.truncate(this.getMaxTime().getMillis())));
        if (!actualInterval.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        if (actualInterval.getStart().isBefore((ReadableInstant)dataInterval.getStart())) {
            actualInterval = actualInterval.withStart((ReadableInstant)dataInterval.getStart());
        }
        if (actualInterval.getEnd().isAfter((ReadableInstant)dataInterval.getEnd())) {
            actualInterval = actualInterval.withEnd((ReadableInstant)dataInterval.getEnd());
        }
        if (filter == null) {
            offset = new NoFilterOffset(0, this.index.getNumRows());
        } else {
            ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(this.index.getBitmapFactoryForDimensions(), this.index);
            offset = new BitmapOffset(selector.getBitmapFactory(), filter.getBitmapIndex(selector));
        }
        return Sequences.filter(new CursorSequenceBuilder(this.index, actualInterval, gran, offset).build(), (Predicate)Predicates.notNull());
    }

    private static class NoFilterOffset
    implements Offset {
        private final int rowCount;
        private volatile int currentOffset;

        NoFilterOffset(int currentOffset, int rowCount) {
            this.currentOffset = currentOffset;
            this.rowCount = rowCount;
        }

        @Override
        public void increment() {
            ++this.currentOffset;
        }

        @Override
        public boolean withinBounds() {
            return this.currentOffset < this.rowCount;
        }

        @Override
        public Offset clone() {
            return new NoFilterOffset(this.currentOffset, this.rowCount);
        }

        @Override
        public int getOffset() {
            return this.currentOffset;
        }
    }

    private static class TimestampCheckingOffset
    implements Offset {
        private final Offset baseOffset;
        private final GenericColumn timestamps;
        private final long threshold;
        private final boolean allWithinThreshold;

        public TimestampCheckingOffset(Offset baseOffset, GenericColumn timestamps, long threshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.threshold = threshold;
            this.allWithinThreshold = timestamps.getLongSingleValueRow(timestamps.length() - 1) < threshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public Offset clone() {
            return new TimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.threshold);
        }

        @Override
        public boolean withinBounds() {
            return this.baseOffset.withinBounds() && (this.allWithinThreshold || this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()) < this.threshold);
        }

        @Override
        public void increment() {
            this.baseOffset.increment();
        }
    }

    private static class CursorSequenceBuilder {
        private final ColumnSelector index;
        private final Interval interval;
        private final QueryGranularity gran;
        private final Offset offset;

        public CursorSequenceBuilder(ColumnSelector index, Interval interval, QueryGranularity gran, Offset offset) {
            this.index = index;
            this.interval = interval;
            this.gran = gran;
            this.offset = offset;
        }

        public Sequence<Cursor> build() {
            final Offset baseOffset = this.offset.clone();
            final HashMap dictionaryColumnCache = Maps.newHashMap();
            final HashMap genericColumnCache = Maps.newHashMap();
            final HashMap complexColumnCache = Maps.newHashMap();
            final HashMap objectColumnCache = Maps.newHashMap();
            final GenericColumn timestamps = this.index.getColumn("__time").getGenericColumn();
            return Sequences.withBaggage((Sequence)Sequences.map((Sequence)Sequences.simple(this.gran.iterable(this.interval.getStartMillis(), this.interval.getEndMillis())), (Function)new Function<Long, Cursor>(){

                public Cursor apply(final Long input) {
                    long timeStart = Math.max(CursorSequenceBuilder.this.interval.getStartMillis(), input);
                    while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                        baseOffset.increment();
                    }
                    final TimestampCheckingOffset offset = new TimestampCheckingOffset(baseOffset, timestamps, Math.min(CursorSequenceBuilder.this.interval.getEndMillis(), CursorSequenceBuilder.this.gran.next(input)));
                    return new Cursor(){
                        private final Offset initOffset;
                        private final DateTime myBucket;
                        private Offset cursorOffset;
                        {
                            this.initOffset = offset.clone();
                            this.myBucket = CursorSequenceBuilder.this.gran.toDateTime(input);
                            this.cursorOffset = offset;
                        }

                        @Override
                        public DateTime getTime() {
                            return this.myBucket;
                        }

                        @Override
                        public void advance() {
                            if (Thread.interrupted()) {
                                throw new QueryInterruptedException();
                            }
                            this.cursorOffset.increment();
                        }

                        @Override
                        public void advanceTo(int offset2) {
                            for (int count = 0; count < offset2 && !this.isDone(); ++count) {
                                this.advance();
                            }
                        }

                        @Override
                        public boolean isDone() {
                            return !this.cursorOffset.withinBounds();
                        }

                        @Override
                        public void reset() {
                            this.cursorOffset = this.initOffset.clone();
                        }

                        @Override
                        public DimensionSelector makeDimensionSelector(String dimension, final @Nullable ExtractionFn extractionFn) {
                            DictionaryEncodedColumn column;
                            Column columnDesc = CursorSequenceBuilder.this.index.getColumn(dimension);
                            if (columnDesc == null) {
                                return NULL_DIMENSION_SELECTOR;
                            }
                            if (dimension.equals("__time")) {
                                return new SingleScanTimeDimSelector(this.makeLongColumnSelector(dimension), extractionFn);
                            }
                            DictionaryEncodedColumn cachedColumn = (DictionaryEncodedColumn)dictionaryColumnCache.get(dimension);
                            if (cachedColumn == null) {
                                cachedColumn = columnDesc.getDictionaryEncoding();
                                dictionaryColumnCache.put(dimension, cachedColumn);
                            }
                            if ((column = cachedColumn) == null) {
                                return NULL_DIMENSION_SELECTOR;
                            }
                            if (columnDesc.getCapabilities().hasMultipleValues()) {
                                return new DimensionSelector(){

                                    @Override
                                    public IndexedInts getRow() {
                                        return column.getMultiValueRow(cursorOffset.getOffset());
                                    }

                                    @Override
                                    public int getValueCardinality() {
                                        return column.getCardinality();
                                    }

                                    @Override
                                    public String lookupName(int id) {
                                        String value = column.lookupName(id);
                                        return extractionFn == null ? Strings.nullToEmpty((String)value) : extractionFn.apply(Strings.nullToEmpty((String)value));
                                    }

                                    @Override
                                    public int lookupId(String name) {
                                        if (extractionFn != null) {
                                            throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                                        }
                                        return column.lookupId(name);
                                    }
                                };
                            }
                            return new DimensionSelector(){

                                @Override
                                public IndexedInts getRow() {
                                    return new IndexedInts(){

                                        @Override
                                        public int size() {
                                            return 1;
                                        }

                                        @Override
                                        public int get(int index) {
                                            return column.getSingleValueRow(cursorOffset.getOffset());
                                        }

                                        @Override
                                        public Iterator<Integer> iterator() {
                                            return Iterators.singletonIterator((Object)column.getSingleValueRow(cursorOffset.getOffset()));
                                        }

                                        @Override
                                        public void fill(int index, int[] toFill) {
                                            throw new UnsupportedOperationException("fill not supported");
                                        }

                                        @Override
                                        public void close() throws IOException {
                                        }
                                    };
                                }

                                @Override
                                public int getValueCardinality() {
                                    return column.getCardinality();
                                }

                                @Override
                                public String lookupName(int id) {
                                    String value = column.lookupName(id);
                                    return extractionFn == null ? value : extractionFn.apply(value);
                                }

                                @Override
                                public int lookupId(String name) {
                                    if (extractionFn != null) {
                                        throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                                    }
                                    return column.lookupId(name);
                                }
                            };
                        }

                        @Override
                        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                            Column holder;
                            GenericColumn cachedMetricVals = (GenericColumn)genericColumnCache.get(columnName);
                            if (cachedMetricVals == null && (holder = CursorSequenceBuilder.this.index.getColumn(columnName)) != null && (holder.getCapabilities().getType() == ValueType.FLOAT || holder.getCapabilities().getType() == ValueType.LONG)) {
                                cachedMetricVals = holder.getGenericColumn();
                                genericColumnCache.put(columnName, cachedMetricVals);
                            }
                            if (cachedMetricVals == null) {
                                return new FloatColumnSelector(){

                                    @Override
                                    public float get() {
                                        return 0.0f;
                                    }
                                };
                            }
                            final GenericColumn metricVals = cachedMetricVals;
                            return new FloatColumnSelector(){

                                @Override
                                public float get() {
                                    return metricVals.getFloatSingleValueRow(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public LongColumnSelector makeLongColumnSelector(String columnName) {
                            Column holder;
                            GenericColumn cachedMetricVals = (GenericColumn)genericColumnCache.get(columnName);
                            if (cachedMetricVals == null && (holder = CursorSequenceBuilder.this.index.getColumn(columnName)) != null && (holder.getCapabilities().getType() == ValueType.LONG || holder.getCapabilities().getType() == ValueType.FLOAT)) {
                                cachedMetricVals = holder.getGenericColumn();
                                genericColumnCache.put(columnName, cachedMetricVals);
                            }
                            if (cachedMetricVals == null) {
                                return new LongColumnSelector(){

                                    @Override
                                    public long get() {
                                        return 0L;
                                    }
                                };
                            }
                            final GenericColumn metricVals = cachedMetricVals;
                            return new LongColumnSelector(){

                                @Override
                                public long get() {
                                    return metricVals.getLongSingleValueRow(cursorOffset.getOffset());
                                }
                            };
                        }

                        @Override
                        public ObjectColumnSelector makeObjectColumnSelector(String column) {
                            Closeable columnVals;
                            Object cachedColumnVals = objectColumnCache.get(column);
                            if (cachedColumnVals == null) {
                                Column holder = CursorSequenceBuilder.this.index.getColumn(column);
                                if (holder != null) {
                                    ColumnCapabilities capabilities = holder.getCapabilities();
                                    cachedColumnVals = capabilities.isDictionaryEncoded() ? holder.getDictionaryEncoding() : (capabilities.getType() == ValueType.COMPLEX ? holder.getComplexColumn() : holder.getGenericColumn());
                                }
                                if (cachedColumnVals != null) {
                                    objectColumnCache.put(column, cachedColumnVals);
                                }
                            }
                            if (cachedColumnVals == null) {
                                return null;
                            }
                            if (cachedColumnVals instanceof GenericColumn) {
                                columnVals = (GenericColumn)cachedColumnVals;
                                ValueType type = columnVals.getType();
                                if (columnVals.hasMultipleValues()) {
                                    throw new UnsupportedOperationException("makeObjectColumnSelector does not support multivalued GenericColumns");
                                }
                                if (type == ValueType.FLOAT) {
                                    return new ObjectColumnSelector<Float>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Float.TYPE;
                                        }

                                        @Override
                                        public Float get() {
                                            return Float.valueOf(this.val$columnVals.getFloatSingleValueRow(cursorOffset.getOffset()));
                                        }
                                    };
                                }
                                if (type == ValueType.LONG) {
                                    return new ObjectColumnSelector<Long>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Long.TYPE;
                                        }

                                        @Override
                                        public Long get() {
                                            return this.val$columnVals.getLongSingleValueRow(cursorOffset.getOffset());
                                        }
                                    };
                                }
                                if (type == ValueType.STRING) {
                                    return new ObjectColumnSelector<String>((GenericColumn)columnVals){
                                        final /* synthetic */ GenericColumn val$columnVals;
                                        {
                                            this.val$columnVals = genericColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return String.class;
                                        }

                                        @Override
                                        public String get() {
                                            return this.val$columnVals.getStringSingleValueRow(cursorOffset.getOffset());
                                        }
                                    };
                                }
                            }
                            if (cachedColumnVals instanceof DictionaryEncodedColumn) {
                                columnVals = (DictionaryEncodedColumn)cachedColumnVals;
                                if (columnVals.hasMultipleValues()) {
                                    return new ObjectColumnSelector<Object>((DictionaryEncodedColumn)columnVals){
                                        final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                                        {
                                            this.val$columnVals = dictionaryEncodedColumn;
                                        }

                                        @Override
                                        public Class classOfObject() {
                                            return Object.class;
                                        }

                                        @Override
                                        public Object get() {
                                            IndexedInts multiValueRow = this.val$columnVals.getMultiValueRow(cursorOffset.getOffset());
                                            if (multiValueRow.size() == 0) {
                                                return null;
                                            }
                                            if (multiValueRow.size() == 1) {
                                                return this.val$columnVals.lookupName(multiValueRow.get(0));
                                            }
                                            String[] strings = new String[multiValueRow.size()];
                                            for (int i = 0; i < multiValueRow.size(); ++i) {
                                                strings[i] = this.val$columnVals.lookupName(multiValueRow.get(i));
                                            }
                                            return strings;
                                        }
                                    };
                                }
                                return new ObjectColumnSelector<String>((DictionaryEncodedColumn)columnVals){
                                    final /* synthetic */ DictionaryEncodedColumn val$columnVals;
                                    {
                                        this.val$columnVals = dictionaryEncodedColumn;
                                    }

                                    @Override
                                    public Class classOfObject() {
                                        return String.class;
                                    }

                                    @Override
                                    public String get() {
                                        return this.val$columnVals.lookupName(this.val$columnVals.getSingleValueRow(cursorOffset.getOffset()));
                                    }
                                };
                            }
                            columnVals = (ComplexColumn)cachedColumnVals;
                            return new ObjectColumnSelector((ComplexColumn)columnVals){
                                final /* synthetic */ ComplexColumn val$columnVals;
                                {
                                    this.val$columnVals = complexColumn;
                                }

                                public Class classOfObject() {
                                    return this.val$columnVals.getClazz();
                                }

                                public Object get() {
                                    return this.val$columnVals.getRowValue(cursorOffset.getOffset());
                                }
                            };
                        }
                    };
                }
            }), (Closeable)new Closeable(){

                @Override
                public void close() throws IOException {
                    CloseQuietly.close((Closeable)timestamps);
                    for (Closeable column : dictionaryColumnCache.values()) {
                        CloseQuietly.close((Closeable)column);
                    }
                    for (Closeable column : genericColumnCache.values()) {
                        CloseQuietly.close((Closeable)column);
                    }
                    for (ComplexColumn complexColumn : complexColumnCache.values()) {
                        CloseQuietly.close((Closeable)complexColumn);
                    }
                    for (Closeable column : objectColumnCache.values()) {
                        if (!(column instanceof Closeable)) continue;
                        CloseQuietly.close((Closeable)column);
                    }
                }
            });
        }
    }
}

