/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.ISE;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.logger.Logger;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Rowboat;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.IndexedFloatsGenericColumn;
import io.druid.segment.column.IndexedLongsGenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.ArrayBasedIndexedInts;
import io.druid.segment.data.BitmapCompressedIndexedInts;
import io.druid.segment.data.EmptyIndexedInts;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.ListIndexed;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.time.Interval;

public class QueryableIndexIndexableAdapter
implements IndexableAdapter {
    private static final Logger log = new Logger(QueryableIndexIndexableAdapter.class);
    private final int numRows;
    private final QueryableIndex input;
    private final List<String> availableDimensions;

    public QueryableIndexIndexableAdapter(QueryableIndex input) {
        this.input = input;
        this.numRows = input.getNumRows();
        this.availableDimensions = Lists.newArrayList();
        for (String dim : input.getAvailableDimensions()) {
            Column col = input.getColumn(dim);
            if (col == null) {
                log.warn("Wtf!? column[%s] didn't exist!?!?!?", new Object[]{dim});
                continue;
            }
            if (col.getDictionaryEncoding() != null) {
                this.availableDimensions.add(dim);
                continue;
            }
            log.info("No dictionary on dimension[%s]", new Object[]{dim});
        }
    }

    @Override
    public Interval getDataInterval() {
        return this.input.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public Indexed<String> getDimensionNames() {
        return new ListIndexed<String>(this.availableDimensions, String.class);
    }

    @Override
    public Indexed<String> getMetricNames() {
        LinkedHashSet columns = Sets.newLinkedHashSet(this.input.getColumnNames());
        HashSet dimensions = Sets.newHashSet(this.getDimensionNames());
        return new ListIndexed<String>(Lists.newArrayList((Iterable)Sets.difference((Set)columns, (Set)dimensions)), String.class);
    }

    @Override
    public Indexed<String> getDimValueLookup(String dimension) {
        Column column = this.input.getColumn(dimension);
        if (column == null) {
            return null;
        }
        final DictionaryEncodedColumn dict = column.getDictionaryEncoding();
        if (dict == null) {
            return null;
        }
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return dict.getCardinality();
            }

            @Override
            public String get(int index) {
                return dict.lookupName(index);
            }

            @Override
            public int indexOf(String value) {
                return dict.lookupId(value);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return new Iterable<Rowboat>(){

            @Override
            public Iterator<Rowboat> iterator() {
                return new Iterator<Rowboat>(){
                    final GenericColumn timestamps;
                    final Object[] metrics;
                    final DictionaryEncodedColumn[] dictionaryEncodedColumns;
                    final int numMetrics;
                    int currRow;
                    boolean done;
                    {
                        this.timestamps = QueryableIndexIndexableAdapter.this.input.getColumn("__time").getGenericColumn();
                        this.numMetrics = QueryableIndexIndexableAdapter.this.getMetricNames().size();
                        this.currRow = 0;
                        this.done = false;
                        this.dictionaryEncodedColumns = (DictionaryEncodedColumn[])FluentIterable.from(QueryableIndexIndexableAdapter.this.getDimensionNames()).transform((Function)new Function<String, DictionaryEncodedColumn>(){

                            public DictionaryEncodedColumn apply(String dimName) {
                                return QueryableIndexIndexableAdapter.this.input.getColumn(dimName).getDictionaryEncoding();
                            }
                        }).toArray(DictionaryEncodedColumn.class);
                        Indexed<String> availableMetrics = QueryableIndexIndexableAdapter.this.getMetricNames();
                        this.metrics = new Object[availableMetrics.size()];
                        block4: for (int i = 0; i < this.metrics.length; ++i) {
                            Column column = QueryableIndexIndexableAdapter.this.input.getColumn(availableMetrics.get(i));
                            ValueType type = column.getCapabilities().getType();
                            switch (type) {
                                case FLOAT: 
                                case LONG: {
                                    this.metrics[i] = column.getGenericColumn();
                                    continue block4;
                                }
                                case COMPLEX: {
                                    this.metrics[i] = column.getComplexColumn();
                                    continue block4;
                                }
                                default: {
                                    throw new ISE("Cannot handle type[%s]", new Object[]{type});
                                }
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        boolean hasNext;
                        boolean bl = hasNext = this.currRow < QueryableIndexIndexableAdapter.this.numRows;
                        if (!hasNext && !this.done) {
                            CloseQuietly.close((Closeable)this.timestamps);
                            for (Object metric : this.metrics) {
                                if (!(metric instanceof Closeable)) continue;
                                CloseQuietly.close((Closeable)((Closeable)metric));
                            }
                            for (DictionaryEncodedColumn dimension : this.dictionaryEncodedColumns) {
                                if (!(dimension instanceof Closeable)) continue;
                                CloseQuietly.close((Closeable)dimension);
                            }
                            this.done = true;
                        }
                        return hasNext;
                    }

                    @Override
                    public Rowboat next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int[][] dims = new int[this.dictionaryEncodedColumns.length][];
                        int dimIndex = 0;
                        for (DictionaryEncodedColumn dict : this.dictionaryEncodedColumns) {
                            IndexedInts dimVals = dict.hasMultipleValues() ? dict.getMultiValueRow(this.currRow) : new ArrayBasedIndexedInts(new int[]{dict.getSingleValueRow(this.currRow)});
                            int[] theVals = new int[dimVals.size()];
                            for (int j = 0; j < theVals.length; ++j) {
                                theVals[j] = dimVals.get(j);
                            }
                            dims[dimIndex++] = theVals;
                        }
                        Object[] metricArray = new Object[this.numMetrics];
                        for (int i = 0; i < metricArray.length; ++i) {
                            if (this.metrics[i] instanceof IndexedFloatsGenericColumn) {
                                metricArray[i] = Float.valueOf(((GenericColumn)this.metrics[i]).getFloatSingleValueRow(this.currRow));
                                continue;
                            }
                            if (this.metrics[i] instanceof IndexedLongsGenericColumn) {
                                metricArray[i] = ((GenericColumn)this.metrics[i]).getLongSingleValueRow(this.currRow);
                                continue;
                            }
                            if (!(this.metrics[i] instanceof ComplexColumn)) continue;
                            metricArray[i] = ((ComplexColumn)this.metrics[i]).getRowValue(this.currRow);
                        }
                        Rowboat retVal = new Rowboat(this.timestamps.getLongSingleValueRow(this.currRow), dims, metricArray, this.currRow);
                        ++this.currRow;
                        return retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public IndexedInts getBitmapIndex(String dimension, String value) {
        Column column = this.input.getColumn(dimension);
        if (column == null) {
            return new EmptyIndexedInts();
        }
        BitmapIndex bitmaps = column.getBitmapIndex();
        if (bitmaps == null) {
            return new EmptyIndexedInts();
        }
        return new BitmapCompressedIndexedInts(bitmaps.getBitmap(value));
    }

    @Override
    public String getMetricType(String metric) {
        Column column = this.input.getColumn(metric);
        ValueType type = column.getCapabilities().getType();
        switch (type) {
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case COMPLEX: {
                return column.getComplexColumn().getTypeName();
            }
        }
        throw new ISE("Unknown type[%s]", new Object[]{type});
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.input.getColumn(column).getCapabilities();
    }
}

