/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.common.IAE;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIntsIterator;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.IndexedMultivalue;
import io.druid.segment.data.WritableSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;

public class CompressedVSizeIndexedSupplier
implements WritableSupplier<IndexedMultivalue<IndexedInts>> {
    private static final byte version = 2;
    private final CompressedVSizeIntsIndexedSupplier offsetSupplier;
    private final CompressedVSizeIntsIndexedSupplier valueSupplier;

    CompressedVSizeIndexedSupplier(CompressedVSizeIntsIndexedSupplier offsetSupplier, CompressedVSizeIntsIndexedSupplier valueSupplier) {
        this.offsetSupplier = offsetSupplier;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public long getSerializedSize() {
        return 1L + this.offsetSupplier.getSerializedSize() + this.valueSupplier.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        this.offsetSupplier.writeToChannel(channel);
        this.valueSupplier.writeToChannel(channel);
    }

    public static CompressedVSizeIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 2) {
            CompressedVSizeIntsIndexedSupplier offsetSupplier = CompressedVSizeIntsIndexedSupplier.fromByteBuffer(buffer, order);
            CompressedVSizeIntsIndexedSupplier valueSupplier = CompressedVSizeIntsIndexedSupplier.fromByteBuffer(buffer, order);
            return new CompressedVSizeIndexedSupplier(offsetSupplier, valueSupplier);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    public static CompressedVSizeIndexedSupplier fromIterable(Iterable<IndexedInts> objectsIterable, int maxValue, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        Iterator<IndexedInts> objects = objectsIterable.iterator();
        ArrayList<Integer> offsetList = new ArrayList<Integer>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        int offset = 0;
        while (objects.hasNext()) {
            IndexedInts next = objects.next();
            offsetList.add(offset);
            for (int i = 0; i < next.size(); ++i) {
                values.add(next.get(i));
            }
            offset += next.size();
        }
        offsetList.add(offset);
        int offsetMax = offset;
        CompressedVSizeIntsIndexedSupplier headerSupplier = CompressedVSizeIntsIndexedSupplier.fromList(offsetList, offsetMax, CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(offsetMax), byteOrder, compression);
        CompressedVSizeIntsIndexedSupplier valuesSupplier = CompressedVSizeIntsIndexedSupplier.fromList(values, maxValue, CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(maxValue), byteOrder, compression);
        return new CompressedVSizeIndexedSupplier(headerSupplier, valuesSupplier);
    }

    public IndexedMultivalue<IndexedInts> get() {
        return new CompressedVSizeIndexed(this.offsetSupplier.get(), this.valueSupplier.get());
    }

    public static class CompressedVSizeIndexed
    implements IndexedMultivalue<IndexedInts> {
        private final IndexedInts offsets;
        private final IndexedInts values;

        CompressedVSizeIndexed(IndexedInts offsets, IndexedInts values) {
            this.offsets = offsets;
            this.values = values;
        }

        @Override
        public void close() throws IOException {
            this.offsets.close();
            this.values.close();
        }

        @Override
        public Class<? extends IndexedInts> getClazz() {
            return IndexedInts.class;
        }

        @Override
        public int size() {
            return this.offsets.size() - 1;
        }

        @Override
        public IndexedInts get(int index) {
            final int offset = this.offsets.get(index);
            final int size = this.offsets.get(index + 1) - offset;
            return new IndexedInts(){

                @Override
                public int size() {
                    return size;
                }

                @Override
                public int get(int index) {
                    if (index >= size) {
                        throw new IllegalArgumentException(String.format("Index[%s] >= size[%s]", index, size));
                    }
                    return CompressedVSizeIndexed.this.values.get(index + offset);
                }

                @Override
                public void fill(int index, int[] toFill) {
                    throw new UnsupportedOperationException("fill not supported");
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<Integer> iterator() {
                    return new IndexedIntsIterator(this);
                }
            };
        }

        @Override
        public int indexOf(IndexedInts value) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }

        @Override
        public Iterator<IndexedInts> iterator() {
            return IndexedIterable.create(this).iterator();
        }
    }
}

