/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.segment.data.Offset;
import org.roaringbitmap.IntIterator;

public class BitmapOffset
implements Offset {
    private static final int INVALID_VALUE = -1;
    private final IntIterator itr;
    private final BitmapFactory bitmapFactory;
    private final ImmutableBitmap bitmapIndex;
    private volatile int val;

    public BitmapOffset(BitmapFactory bitmapFactory, ImmutableBitmap bitmapIndex) {
        this.bitmapFactory = bitmapFactory;
        this.bitmapIndex = bitmapIndex;
        this.itr = bitmapIndex.iterator();
        this.increment();
    }

    private BitmapOffset(BitmapOffset otherOffset) {
        this.bitmapFactory = otherOffset.bitmapFactory;
        this.bitmapIndex = otherOffset.bitmapIndex;
        this.itr = otherOffset.itr.clone();
        this.val = otherOffset.val;
    }

    @Override
    public void increment() {
        this.val = this.itr.hasNext() ? this.itr.next() : -1;
    }

    @Override
    public boolean withinBounds() {
        return this.val > -1;
    }

    @Override
    public Offset clone() {
        if (this.bitmapIndex == null || this.bitmapIndex.size() == 0) {
            return new BitmapOffset(this.bitmapFactory, this.bitmapFactory.makeEmptyImmutableBitmap());
        }
        return new BitmapOffset(this);
    }

    @Override
    public int getOffset() {
        return this.val;
    }
}

