/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import io.druid.collections.StupidPool;
import io.druid.guice.annotations.Global;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryEngine;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.Segment;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class TopNQueryRunnerFactory
implements QueryRunnerFactory<Result<TopNResultValue>, TopNQuery> {
    private final StupidPool<ByteBuffer> computationBufferPool;
    private final TopNQueryQueryToolChest toolchest;
    private final QueryWatcher queryWatcher;

    @Inject
    public TopNQueryRunnerFactory(@Global StupidPool<ByteBuffer> computationBufferPool, TopNQueryQueryToolChest toolchest, QueryWatcher queryWatcher) {
        this.computationBufferPool = computationBufferPool;
        this.toolchest = toolchest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> createRunner(final Segment segment) {
        final TopNQueryEngine queryEngine = new TopNQueryEngine(this.computationBufferPool);
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(Query<Result<TopNResultValue>> input, Map<String, Object> responseContext) {
                if (!(input instanceof TopNQuery)) {
                    throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), TopNQuery.class});
                }
                return queryEngine.query((TopNQuery)input, segment.asStorageAdapter());
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<TopNResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TopNResultValue>>(queryExecutor, this.toolchest.getOrdering(), this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TopNResultValue>, TopNQuery> getToolchest() {
        return this.toolchest;
    }
}

