/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Function;
import io.druid.query.Result;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;

public class TopNMapFn
implements Function<Cursor, Result<TopNResultValue>> {
    private final TopNQuery query;
    private final TopNAlgorithm topNAlgorithm;

    public TopNMapFn(TopNQuery query, TopNAlgorithm topNAlgorithm) {
        this.query = query;
        this.topNAlgorithm = topNAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<TopNResultValue> apply(Cursor cursor) {
        DimensionSelector dimSelector = cursor.makeDimensionSelector(this.query.getDimensionSpec().getDimension(), this.query.getDimensionSpec().getExtractionFn());
        if (dimSelector == null) {
            return null;
        }
        TopNParams params = null;
        try {
            params = this.topNAlgorithm.makeInitParams(dimSelector, cursor);
            TopNResultBuilder resultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, this.query);
            this.topNAlgorithm.run(params, resultBuilder, null);
            Result<TopNResultValue> result = resultBuilder.build();
            return result;
        }
        finally {
            this.topNAlgorithm.cleanup(params);
        }
    }
}

