/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.StringUtils;
import io.druid.query.search.search.SearchQuerySpec;
import java.nio.ByteBuffer;

public class InsensitiveContainsSearchQuerySpec
implements SearchQuerySpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String value;

    @JsonCreator
    public InsensitiveContainsSearchQuerySpec(@JsonProperty(value="value") String value) {
        this.value = value;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean accept(String dimVal) {
        if (dimVal == null) {
            return false;
        }
        return dimVal.toLowerCase().contains(this.value.toLowerCase());
    }

    @Override
    public byte[] getCacheKey() {
        byte[] valueBytes = StringUtils.toUtf8((String)this.value);
        return ByteBuffer.allocate(1 + valueBytes.length).put((byte)1).put(valueBytes).array();
    }

    public String toString() {
        return "InsensitiveContainsSearchQuerySpec{value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsensitiveContainsSearchQuerySpec that = (InsensitiveContainsSearchQuerySpec)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

