/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.StringUtils;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class ListColumnIncluderator
implements ColumnIncluderator {
    private final Set<String> columns = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);

    @JsonCreator
    public ListColumnIncluderator(@JsonProperty(value="columns") List<String> columns) {
        this.columns.addAll(columns);
    }

    @JsonProperty
    public Set<String> getColumns() {
        return Collections.unmodifiableSet(this.columns);
    }

    @Override
    public boolean include(String columnName) {
        return this.columns.contains(columnName);
    }

    @Override
    public byte[] getCacheKey() {
        int size = 1;
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)this.columns.size());
        for (String column : this.columns) {
            byte[] bytes = StringUtils.toUtf8((String)column);
            columns.add(bytes);
            size += bytes.length;
        }
        ByteBuffer bytes = ByteBuffer.allocate(size).put(LIST_CACHE_PREFIX);
        for (byte[] column : columns) {
            bytes.put(column);
        }
        return bytes.array();
    }
}

