/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.orderby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OrderByColumnSpec {
    private static final Map<String, Direction> stupidEnumMap;
    private final String dimension;
    private final Direction direction;

    @JsonCreator
    public static OrderByColumnSpec create(Object obj) {
        Preconditions.checkNotNull((Object)obj, (Object)"Cannot build an OrderByColumnSpec from a null object.");
        if (obj instanceof String) {
            return new OrderByColumnSpec(obj.toString(), null);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            String dimension = map.get("dimension").toString();
            Direction direction = OrderByColumnSpec.determineDirection(map.get("direction"));
            return new OrderByColumnSpec(dimension, direction);
        }
        throw new ISE("Cannot build an OrderByColumnSpec from a %s", new Object[]{obj.getClass()});
    }

    public static OrderByColumnSpec asc(String dimension) {
        return new OrderByColumnSpec(dimension, Direction.ASCENDING);
    }

    public static List<OrderByColumnSpec> ascending(String ... dimension) {
        return Lists.transform(Arrays.asList(dimension), (Function)new Function<String, OrderByColumnSpec>(){

            public OrderByColumnSpec apply(@Nullable String input) {
                return OrderByColumnSpec.asc(input);
            }
        });
    }

    public static OrderByColumnSpec desc(String dimension) {
        return new OrderByColumnSpec(dimension, Direction.DESCENDING);
    }

    public static List<OrderByColumnSpec> descending(String ... dimension) {
        return Lists.transform(Arrays.asList(dimension), (Function)new Function<String, OrderByColumnSpec>(){

            public OrderByColumnSpec apply(@Nullable String input) {
                return OrderByColumnSpec.desc(input);
            }
        });
    }

    public OrderByColumnSpec(String dimension, Direction direction) {
        this.dimension = dimension;
        this.direction = direction == null ? Direction.ASCENDING : direction;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Direction getDirection() {
        return this.direction;
    }

    public static Direction determineDirection(Object directionObj) {
        if (directionObj == null) {
            return null;
        }
        String directionString = directionObj.toString();
        Direction direction = stupidEnumMap.get(directionString);
        if (direction == null) {
            String lowerDimension = directionString.toLowerCase();
            for (Direction dir : Direction.values()) {
                if (!dir.toString().toLowerCase().startsWith(lowerDimension)) continue;
                if (direction != null) {
                    throw new ISE("Ambiguous directions[%s] and [%s]", new Object[]{direction, dir});
                }
                direction = dir;
            }
        }
        if (direction == null) {
            throw new IAE("Unknown direction[%s]", new Object[]{directionString});
        }
        return direction;
    }

    public String toString() {
        return "OrderByColumnSpec{dimension='" + this.dimension + '\'' + ", direction=" + (Object)((Object)this.direction) + '}';
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] directionBytes = StringUtils.toUtf8((String)this.direction.name());
        return ByteBuffer.allocate(dimensionBytes.length + directionBytes.length).put(dimensionBytes).put(directionBytes).array();
    }

    static {
        ImmutableMap.Builder bob = ImmutableMap.builder();
        for (Direction direction : Direction.values()) {
            bob.put((Object)direction.toString(), (Object)direction);
        }
        stupidEnumMap = bob.build();
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

