/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.FunctionalIterator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.parsers.CloseableIterator;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.guice.annotations.Global;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryEngine {
    private final Supplier<GroupByQueryConfig> config;
    private final StupidPool<ByteBuffer> intermediateResultsBufferPool;

    @Inject
    public GroupByQueryEngine(Supplier<GroupByQueryConfig> config, @Global StupidPool<ByteBuffer> intermediateResultsBufferPool) {
        this.config = config;
        this.intermediateResultsBufferPool = intermediateResultsBufferPool;
    }

    public Sequence<Row> process(final GroupByQuery query, StorageAdapter storageAdapter) {
        if (storageAdapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", new Object[]{intervals});
        }
        Sequence<Cursor> cursors = storageAdapter.makeCursors(Filters.convertDimensionFilters(query.getDimFilter()), intervals.get(0), query.getGranularity());
        final ResourceHolder bufferHolder = this.intermediateResultsBufferPool.take();
        return Sequences.concat((Sequence)Sequences.withBaggage((Sequence)Sequences.map(cursors, (Function)new Function<Cursor, Sequence<Row>>(){

            public Sequence<Row> apply(final Cursor cursor) {
                return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Row, RowIterator>(){

                    public RowIterator make() {
                        return new RowIterator(query, cursor, (ByteBuffer)bufferHolder.get(), (GroupByQueryConfig)GroupByQueryEngine.this.config.get());
                    }

                    public void cleanup(RowIterator iterFromMake) {
                        CloseQuietly.close((Closeable)((Object)iterFromMake));
                    }
                });
            }
        }), (Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                CloseQuietly.close((Closeable)bufferHolder);
            }
        }));
    }

    private static class RowIterator
    implements CloseableIterator<Row> {
        private final GroupByQuery query;
        private final Cursor cursor;
        private final ByteBuffer metricsBuffer;
        private final GroupByQueryConfig config;
        private final List<DimensionSpec> dimensionSpecs;
        private final List<DimensionSelector> dimensions;
        private final ArrayList<String> dimNames;
        private final List<AggregatorFactory> aggregatorSpecs;
        private final BufferAggregator[] aggregators;
        private final String[] metricNames;
        private final int[] sizesRequired;
        private List<ByteBuffer> unprocessedKeys;
        private Iterator<Row> delegate;

        public RowIterator(GroupByQuery query, Cursor cursor, ByteBuffer metricsBuffer, GroupByQueryConfig config) {
            int i;
            this.query = query;
            this.cursor = cursor;
            this.metricsBuffer = metricsBuffer;
            this.config = config;
            this.unprocessedKeys = null;
            this.delegate = Iterators.emptyIterator();
            this.dimensionSpecs = query.getDimensions();
            this.dimensions = Lists.newArrayListWithExpectedSize((int)this.dimensionSpecs.size());
            this.dimNames = Lists.newArrayListWithExpectedSize((int)this.dimensionSpecs.size());
            for (i = 0; i < this.dimensionSpecs.size(); ++i) {
                DimensionSpec dimSpec = this.dimensionSpecs.get(i);
                DimensionSelector selector = cursor.makeDimensionSelector(dimSpec.getDimension(), dimSpec.getExtractionFn());
                if (selector == null) continue;
                this.dimensions.add(selector);
                this.dimNames.add(dimSpec.getOutputName());
            }
            this.aggregatorSpecs = query.getAggregatorSpecs();
            this.aggregators = new BufferAggregator[this.aggregatorSpecs.size()];
            this.metricNames = new String[this.aggregatorSpecs.size()];
            this.sizesRequired = new int[this.aggregatorSpecs.size()];
            for (i = 0; i < this.aggregatorSpecs.size(); ++i) {
                AggregatorFactory aggregatorSpec = this.aggregatorSpecs.get(i);
                this.aggregators[i] = aggregatorSpec.factorizeBuffered(cursor);
                this.metricNames[i] = aggregatorSpec.getName();
                this.sizesRequired[i] = aggregatorSpec.getMaxIntermediateSize();
            }
        }

        public boolean hasNext() {
            return this.delegate.hasNext() || !this.cursor.isDone();
        }

        public Row next() {
            if (this.delegate.hasNext()) {
                return this.delegate.next();
            }
            if (this.unprocessedKeys == null && this.cursor.isDone()) {
                throw new NoSuchElementException();
            }
            final PositionMaintainer positionMaintainer = new PositionMaintainer(0, this.sizesRequired, this.metricsBuffer.remaining());
            RowUpdater rowUpdater = new RowUpdater(this.metricsBuffer, this.aggregators, positionMaintainer);
            if (this.unprocessedKeys != null) {
                for (ByteBuffer key : this.unprocessedKeys) {
                    List unprocUnproc = rowUpdater.updateValues(key, (List)ImmutableList.of());
                    if (unprocUnproc == null) continue;
                    throw new ISE("Not enough memory to process the request.", new Object[0]);
                }
                this.cursor.advance();
            }
            while (!this.cursor.isDone()) {
                ByteBuffer key = ByteBuffer.allocate(this.dimensions.size() * 4);
                this.unprocessedKeys = rowUpdater.updateValues(key, this.dimensions);
                if (this.unprocessedKeys != null || rowUpdater.getNumRows() > this.config.getMaxIntermediateRows()) break;
                this.cursor.advance();
            }
            if (rowUpdater.getPositions().isEmpty() && this.unprocessedKeys != null) {
                throw new ISE("Not enough memory to process even a single item.  Required [%,d] memory, but only have[%,d]", new Object[]{positionMaintainer.getIncrement(), this.metricsBuffer.remaining()});
            }
            this.delegate = FunctionalIterator.create(rowUpdater.getPositions().entrySet().iterator()).transform((Function)new Function<Map.Entry<ByteBuffer, Integer>, Row>(){
                private final DateTime timestamp;
                private final int[] increments;
                {
                    this.timestamp = RowIterator.this.cursor.getTime();
                    this.increments = positionMaintainer.getIncrements();
                }

                public Row apply(@Nullable Map.Entry<ByteBuffer, Integer> input) {
                    LinkedHashMap theEvent = Maps.newLinkedHashMap();
                    ByteBuffer keyBuffer = input.getKey().duplicate();
                    for (int i = 0; i < RowIterator.this.dimensions.size(); ++i) {
                        DimensionSelector dimSelector = (DimensionSelector)RowIterator.this.dimensions.get(i);
                        int dimVal = keyBuffer.getInt();
                        if (dimSelector.getValueCardinality() == dimVal) continue;
                        theEvent.put(RowIterator.this.dimNames.get(i), dimSelector.lookupName(dimVal));
                    }
                    int position = input.getValue();
                    for (int i = 0; i < RowIterator.this.aggregators.length; ++i) {
                        theEvent.put(RowIterator.this.metricNames[i], RowIterator.this.aggregators[i].get(RowIterator.this.metricsBuffer, position));
                        position += this.increments[i];
                    }
                    for (PostAggregator postAggregator : RowIterator.this.query.getPostAggregatorSpecs()) {
                        theEvent.put(postAggregator.getName(), postAggregator.compute(theEvent));
                    }
                    return new MapBasedRow(this.timestamp, (Map)theEvent);
                }
            });
            return this.delegate.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            for (BufferAggregator agg : this.aggregators) {
                agg.close();
            }
        }
    }

    private static class PositionMaintainer {
        private final int[] increments;
        private final int increment;
        private final int max;
        private long nextVal;

        public PositionMaintainer(int start, int[] increments, int max) {
            this.nextVal = start;
            this.increments = increments;
            int theIncrement = 0;
            for (int i = 0; i < increments.length; ++i) {
                theIncrement += increments[i];
            }
            this.increment = theIncrement;
            this.max = max - this.increment;
        }

        public Integer getNext() {
            if (this.nextVal > (long)this.max) {
                return null;
            }
            int retVal = (int)this.nextVal;
            this.nextVal += (long)this.increment;
            return retVal;
        }

        public int getIncrement() {
            return this.increment;
        }

        public int[] getIncrements() {
            return this.increments;
        }
    }

    private static class RowUpdater {
        private final ByteBuffer metricValues;
        private final BufferAggregator[] aggregators;
        private final PositionMaintainer positionMaintainer;
        private final Map<ByteBuffer, Integer> positions = Maps.newTreeMap();
        private final Map<ByteBuffer, Integer> positionsHash = Maps.newHashMap();

        public RowUpdater(ByteBuffer metricValues, BufferAggregator[] aggregators, PositionMaintainer positionMaintainer) {
            this.metricValues = metricValues;
            this.aggregators = aggregators;
            this.positionMaintainer = positionMaintainer;
        }

        public int getNumRows() {
            return this.positions.size();
        }

        public Map<ByteBuffer, Integer> getPositions() {
            return this.positions;
        }

        private List<ByteBuffer> updateValues(ByteBuffer key, List<DimensionSelector> dims) {
            int thePosition;
            if (dims.size() > 0) {
                ArrayList retVal = null;
                List<ByteBuffer> unaggregatedBuffers = null;
                DimensionSelector dimSelector = dims.get(0);
                IndexedInts row = dimSelector.getRow();
                if (row == null || row.size() == 0) {
                    ByteBuffer newKey = key.duplicate();
                    newKey.putInt(dimSelector.getValueCardinality());
                    unaggregatedBuffers = this.updateValues(newKey, dims.subList(1, dims.size()));
                } else {
                    for (Integer dimValue : row) {
                        ByteBuffer newKey = key.duplicate();
                        newKey.putInt(dimValue);
                        unaggregatedBuffers = this.updateValues(newKey, dims.subList(1, dims.size()));
                    }
                }
                if (unaggregatedBuffers != null) {
                    if (retVal == null) {
                        retVal = Lists.newArrayList();
                    }
                    retVal.addAll(unaggregatedBuffers);
                }
                return retVal;
            }
            key.clear();
            Integer position = this.positionsHash.get(key);
            int[] increments = this.positionMaintainer.getIncrements();
            if (position == null) {
                ByteBuffer keyCopy = ByteBuffer.allocate(key.limit());
                keyCopy.put(key.asReadOnlyBuffer());
                keyCopy.clear();
                position = this.positionMaintainer.getNext();
                if (position == null) {
                    return Lists.newArrayList((Object[])new ByteBuffer[]{keyCopy});
                }
                this.positions.put(keyCopy, position);
                this.positionsHash.put(keyCopy, position);
                thePosition = position;
                for (int i = 0; i < this.aggregators.length; ++i) {
                    this.aggregators[i].init(this.metricValues, thePosition);
                    thePosition += increments[i];
                }
            }
            thePosition = position;
            for (int i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].aggregate(this.metricValues, thePosition);
                thePosition += increments[i];
            }
            return null;
        }
    }
}

