/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.Row;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Queries;
import io.druid.query.Query;
import io.druid.query.QueryDataSource;
import io.druid.query.TableDataSource;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.NoopLimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;

public class GroupByQuery
extends BaseQuery<Row> {
    private final LimitSpec limitSpec;
    private final HavingSpec havingSpec;
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<DimensionSpec> dimensions;
    private final List<AggregatorFactory> aggregatorSpecs;
    private final List<PostAggregator> postAggregatorSpecs;
    private final Function<Sequence<Row>, Sequence<Row>> limitFn;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public GroupByQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="dimensions") List<DimensionSpec> dimensions, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregatorSpecs, @JsonProperty(value="postAggregations") List<PostAggregator> postAggregatorSpecs, @JsonProperty(value="having") HavingSpec havingSpec, @JsonProperty(value="limitSpec") LimitSpec limitSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions == null ? ImmutableList.of() : dimensions;
        for (DimensionSpec spec : this.dimensions) {
            Preconditions.checkArgument((spec != null ? 1 : 0) != 0, (Object)"dimensions has null DimensionSpec");
        }
        this.aggregatorSpecs = aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs == null ? ImmutableList.of() : postAggregatorSpecs;
        this.havingSpec = havingSpec;
        this.limitSpec = limitSpec == null ? new NoopLimitSpec() : limitSpec;
        Preconditions.checkNotNull((Object)this.granularity, (Object)"Must specify a granularity");
        Preconditions.checkNotNull(this.aggregatorSpecs, (Object)"Must specify at least one aggregator");
        Queries.verifyAggregations(this.aggregatorSpecs, this.postAggregatorSpecs);
        Function postProcFn = this.limitSpec.build(this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs);
        if (havingSpec != null) {
            postProcFn = Functions.compose(postProcFn, (Function)new Function<Sequence<Row>, Sequence<Row>>(){

                public Sequence<Row> apply(Sequence<Row> input) {
                    return Sequences.filter(input, (Predicate)new Predicate<Row>(){

                        public boolean apply(Row input) {
                            return GroupByQuery.this.havingSpec.eval(input);
                        }
                    });
                }
            });
        }
        this.limitFn = postProcFn;
    }

    private GroupByQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, DimFilter dimFilter, QueryGranularity granularity, List<DimensionSpec> dimensions, List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs, HavingSpec havingSpec, LimitSpec orderBySpec, Function<Sequence<Row>, Sequence<Row>> limitFn, Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions;
        this.aggregatorSpecs = aggregatorSpecs;
        this.postAggregatorSpecs = postAggregatorSpecs;
        this.havingSpec = havingSpec;
        this.limitSpec = orderBySpec;
        this.limitFn = limitFn;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    @JsonProperty(value="postAggregations")
    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    @JsonProperty(value="having")
    public HavingSpec getHavingSpec() {
        return this.havingSpec;
    }

    @JsonProperty
    public LimitSpec getLimitSpec() {
        return this.limitSpec;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "groupBy";
    }

    public Sequence<Row> applyLimit(Sequence<Row> results) {
        return (Sequence)this.limitFn.apply(results);
    }

    public GroupByQuery withOverriddenContext(Map<String, Object> contextOverride) {
        return new GroupByQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, this.limitSpec, this.limitFn, this.computeOverridenContext(contextOverride));
    }

    public GroupByQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new GroupByQuery(this.getDataSource(), spec, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, this.limitSpec, this.limitFn, this.getContext());
    }

    @Override
    public Query<Row> withDataSource(DataSource dataSource) {
        return new GroupByQuery(dataSource, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, this.limitSpec, this.limitFn, this.getContext());
    }

    public GroupByQuery withDimensionSpecs(List<DimensionSpec> dimensionSpecs) {
        return new GroupByQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.getDimFilter(), this.getGranularity(), dimensionSpecs, this.getAggregatorSpecs(), this.getPostAggregatorSpecs(), this.getHavingSpec(), this.getLimitSpec(), this.limitFn, this.getContext());
    }

    public String toString() {
        return "GroupByQuery{limitSpec=" + this.limitSpec + ", dimFilter=" + this.dimFilter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", aggregatorSpecs=" + this.aggregatorSpecs + ", postAggregatorSpecs=" + this.postAggregatorSpecs + ", limitFn=" + this.limitFn + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByQuery that = (GroupByQuery)o;
        if (this.aggregatorSpecs != null ? !this.aggregatorSpecs.equals(that.aggregatorSpecs) : that.aggregatorSpecs != null) {
            return false;
        }
        if (this.dimFilter != null ? !this.dimFilter.equals(that.dimFilter) : that.dimFilter != null) {
            return false;
        }
        if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(that.granularity) : that.granularity != null) {
            return false;
        }
        if (this.havingSpec != null ? !this.havingSpec.equals(that.havingSpec) : that.havingSpec != null) {
            return false;
        }
        if (this.limitSpec != null ? !this.limitSpec.equals(that.limitSpec) : that.limitSpec != null) {
            return false;
        }
        if (this.limitFn != null ? !this.limitFn.equals(that.limitFn) : that.limitFn != null) {
            return false;
        }
        return !(this.postAggregatorSpecs != null ? !this.postAggregatorSpecs.equals(that.postAggregatorSpecs) : that.postAggregatorSpecs != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.limitSpec != null ? this.limitSpec.hashCode() : 0);
        result = 31 * result + (this.havingSpec != null ? this.havingSpec.hashCode() : 0);
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.aggregatorSpecs != null ? this.aggregatorSpecs.hashCode() : 0);
        result = 31 * result + (this.postAggregatorSpecs != null ? this.postAggregatorSpecs.hashCode() : 0);
        result = 31 * result + (this.limitFn != null ? this.limitFn.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private DataSource dataSource;
        private QuerySegmentSpec querySegmentSpec;
        private DimFilter dimFilter;
        private QueryGranularity granularity;
        private List<DimensionSpec> dimensions;
        private List<AggregatorFactory> aggregatorSpecs;
        private List<PostAggregator> postAggregatorSpecs;
        private HavingSpec havingSpec;
        private Map<String, Object> context;
        private LimitSpec limitSpec = null;
        private List<OrderByColumnSpec> orderByColumnSpecs = Lists.newArrayList();
        private int limit = Integer.MAX_VALUE;

        public Builder() {
        }

        public Builder(GroupByQuery query) {
            this.dataSource = query.getDataSource();
            this.querySegmentSpec = query.getQuerySegmentSpec();
            this.limitSpec = query.getLimitSpec();
            this.dimFilter = query.getDimFilter();
            this.granularity = query.getGranularity();
            this.dimensions = query.getDimensions();
            this.aggregatorSpecs = query.getAggregatorSpecs();
            this.postAggregatorSpecs = query.getPostAggregatorSpecs();
            this.havingSpec = query.getHavingSpec();
            this.context = query.getContext();
        }

        public Builder(Builder builder) {
            this.dataSource = builder.dataSource;
            this.querySegmentSpec = builder.querySegmentSpec;
            this.limitSpec = builder.limitSpec;
            this.dimFilter = builder.dimFilter;
            this.granularity = builder.granularity;
            this.dimensions = builder.dimensions;
            this.aggregatorSpecs = builder.aggregatorSpecs;
            this.postAggregatorSpecs = builder.postAggregatorSpecs;
            this.havingSpec = builder.havingSpec;
            this.limit = builder.limit;
            this.context = builder.context;
        }

        public Builder setDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = new TableDataSource(dataSource);
            return this;
        }

        public Builder setDataSource(Query query) {
            this.dataSource = new QueryDataSource(query);
            return this;
        }

        public Builder setInterval(QuerySegmentSpec interval) {
            return this.setQuerySegmentSpec(interval);
        }

        public Builder setInterval(List<Interval> intervals) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec((Object)intervals));
        }

        public Builder setInterval(Interval interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder setInterval(String interval) {
            return this.setQuerySegmentSpec(new LegacySegmentSpec(interval));
        }

        public Builder limit(int limit) {
            this.ensureExplicitLimitNotSet();
            this.limit = limit;
            return this;
        }

        public Builder addOrderByColumn(String dimension) {
            return this.addOrderByColumn(dimension, (OrderByColumnSpec.Direction)null);
        }

        public Builder addOrderByColumn(String dimension, String direction) {
            return this.addOrderByColumn(dimension, OrderByColumnSpec.determineDirection(direction));
        }

        public Builder addOrderByColumn(String dimension, OrderByColumnSpec.Direction direction) {
            return this.addOrderByColumn(new OrderByColumnSpec(dimension, direction));
        }

        public Builder addOrderByColumn(OrderByColumnSpec columnSpec) {
            this.ensureExplicitLimitNotSet();
            this.orderByColumnSpecs.add(columnSpec);
            return this;
        }

        public Builder setLimitSpec(LimitSpec limitSpec) {
            this.ensureFluentLimitsNotSet();
            this.limitSpec = limitSpec;
            return this;
        }

        private void ensureExplicitLimitNotSet() {
            if (this.limitSpec != null) {
                throw new ISE("Ambiguous build, limitSpec[%s] already set", new Object[]{this.limitSpec});
            }
        }

        private void ensureFluentLimitsNotSet() {
            if (this.limit != Integer.MAX_VALUE || !this.orderByColumnSpecs.isEmpty()) {
                throw new ISE("Ambiguous build, limit[%s] or columnSpecs[%s] already set.", new Object[]{this.limit, this.orderByColumnSpecs});
            }
        }

        public Builder setQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
            this.querySegmentSpec = querySegmentSpec;
            return this;
        }

        public Builder setDimFilter(DimFilter dimFilter) {
            this.dimFilter = dimFilter;
            return this;
        }

        public Builder setGranularity(QueryGranularity granularity) {
            this.granularity = granularity;
            return this;
        }

        public Builder addDimension(String column) {
            return this.addDimension(column, column);
        }

        public Builder addDimension(String column, String outputName) {
            return this.addDimension(new DefaultDimensionSpec(column, outputName));
        }

        public Builder addDimension(DimensionSpec dimension) {
            if (this.dimensions == null) {
                this.dimensions = Lists.newArrayList();
            }
            this.dimensions.add(dimension);
            return this;
        }

        public Builder setDimensions(List<DimensionSpec> dimensions) {
            this.dimensions = Lists.newArrayList(dimensions);
            return this;
        }

        public Builder addAggregator(AggregatorFactory aggregator) {
            if (this.aggregatorSpecs == null) {
                this.aggregatorSpecs = Lists.newArrayList();
            }
            this.aggregatorSpecs.add(aggregator);
            return this;
        }

        public Builder setAggregatorSpecs(List<AggregatorFactory> aggregatorSpecs) {
            this.aggregatorSpecs = Lists.newArrayList(aggregatorSpecs);
            return this;
        }

        public Builder addPostAggregator(PostAggregator postAgg) {
            if (this.postAggregatorSpecs == null) {
                this.postAggregatorSpecs = Lists.newArrayList();
            }
            this.postAggregatorSpecs.add(postAgg);
            return this;
        }

        public Builder setPostAggregatorSpecs(List<PostAggregator> postAggregatorSpecs) {
            this.postAggregatorSpecs = Lists.newArrayList(postAggregatorSpecs);
            return this;
        }

        public Builder setContext(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public Builder setHavingSpec(HavingSpec havingSpec) {
            this.havingSpec = havingSpec;
            return this;
        }

        public Builder setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public GroupByQuery build() {
            LimitSpec theLimitSpec = this.limitSpec == null ? (this.orderByColumnSpecs.isEmpty() && this.limit == Integer.MAX_VALUE ? new NoopLimitSpec() : new DefaultLimitSpec(this.orderByColumnSpecs, this.limit)) : this.limitSpec;
            return new GroupByQuery(this.dataSource, this.querySegmentSpec, this.dimFilter, this.granularity, this.dimensions, this.aggregatorSpecs, this.postAggregatorSpecs, this.havingSpec, theLimitSpec, this.context);
        }
    }
}

