/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.FunctionalExtraction;
import io.druid.query.extraction.LookupExtractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public class LookupExtractionFn
extends FunctionalExtraction {
    private static final byte CACHE_TYPE_ID = 5;
    private final LookupExtractor lookup;

    @JsonCreator
    public LookupExtractionFn(final @JsonProperty(value="lookup") LookupExtractor lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @Nullable @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith, @JsonProperty(value="injective") boolean injective) {
        super(new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                return lookup.apply(Strings.nullToEmpty((String)input));
            }
        }, retainMissingValue, replaceMissingValueWith, injective);
        this.lookup = lookup;
    }

    @JsonProperty
    public LookupExtractor getLookup() {
        return this.lookup;
    }

    @Override
    @JsonProperty
    public boolean isRetainMissingValue() {
        return super.isRetainMissingValue();
    }

    @Override
    @JsonProperty
    public String getReplaceMissingValueWith() {
        return super.getReplaceMissingValueWith();
    }

    @Override
    @JsonProperty
    public boolean isInjective() {
        return super.isInjective();
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(5);
            outputStream.write(this.lookup.getCacheKey());
            if (this.getReplaceMissingValueWith() != null) {
                outputStream.write(StringUtils.toUtf8((String)this.getReplaceMissingValueWith()));
            }
            outputStream.write(this.isInjective() ? 1 : 0);
            outputStream.write(this.isRetainMissingValue() ? 1 : 0);
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

