/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.datasourcemetadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.query.BySegmentSkippingQueryRunner;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import io.druid.query.datasourcemetadata.DataSourceMetadataResultValue;
import io.druid.timeline.LogicalSegment;
import java.util.List;
import java.util.Map;
import org.joda.time.ReadableInterval;

public class DataSourceQueryQueryToolChest
extends QueryToolChest<Result<DataSourceMetadataResultValue>, DataSourceMetadataQuery> {
    private static final TypeReference<Result<DataSourceMetadataResultValue>> TYPE_REFERENCE = new TypeReference<Result<DataSourceMetadataResultValue>>(){};

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(DataSourceMetadataQuery query, List<T> segments) {
        if (segments.size() <= 1) {
            return segments;
        }
        final LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        return Lists.newArrayList((Iterable)Iterables.filter(segments, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return max != null && input.getInterval().overlaps((ReadableInterval)max.getInterval());
            }
        }));
    }

    @Override
    public QueryRunner<Result<DataSourceMetadataResultValue>> mergeResults(QueryRunner<Result<DataSourceMetadataResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<DataSourceMetadataResultValue>>(runner){

            @Override
            protected Sequence<Result<DataSourceMetadataResultValue>> doRun(QueryRunner<Result<DataSourceMetadataResultValue>> baseRunner, Query<Result<DataSourceMetadataResultValue>> input, Map<String, Object> context) {
                DataSourceMetadataQuery query = (DataSourceMetadataQuery)input;
                return Sequences.simple(query.mergeResults(Sequences.toList(baseRunner.run(query, context), (List)Lists.newArrayList())));
            }
        };
    }

    @Override
    public Sequence<Result<DataSourceMetadataResultValue>> mergeSequences(Sequence<Sequence<Result<DataSourceMetadataResultValue>>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public Sequence<Result<DataSourceMetadataResultValue>> mergeSequencesUnordered(Sequence<Sequence<Result<DataSourceMetadataResultValue>>> seqOfSequences) {
        return new MergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(DataSourceMetadataQuery query) {
        return new ServiceMetricEvent.Builder().setDimension("dataSource", DataSourceUtil.getMetricName(query.getDataSource())).setDimension("type", query.getType());
    }

    @Override
    public Function<Result<DataSourceMetadataResultValue>, Result<DataSourceMetadataResultValue>> makePreComputeManipulatorFn(DataSourceMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<DataSourceMetadataResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy getCacheStrategy(DataSourceMetadataQuery query) {
        return null;
    }

    public Ordering<Result<DataSourceMetadataResultValue>> getOrdering() {
        return Ordering.natural();
    }
}

