/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregator;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;
import java.util.List;

public class CardinalityBufferAggregator
implements BufferAggregator {
    private final List<DimensionSelector> selectorList;
    private final boolean byRow;
    private static final byte[] EMPTY_BYTES = HyperLogLogCollector.makeEmptyVersionedByteArray();

    public CardinalityBufferAggregator(List<DimensionSelector> selectorList, boolean byRow) {
        this.selectorList = selectorList;
        this.byRow = byRow;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.put(EMPTY_BYTES);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        HyperLogLogCollector collector = HyperLogLogCollector.makeCollector((ByteBuffer)buf.duplicate().position(position).limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage()));
        if (this.byRow) {
            CardinalityAggregator.hashRow(this.selectorList, collector);
        } else {
            CardinalityAggregator.hashValues(this.selectorList, collector);
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        ByteBuffer dataCopyBuffer = ByteBuffer.allocate(HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.get(dataCopyBuffer.array());
        return HyperLogLogCollector.makeCollector(dataCopyBuffer);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("CardinalityBufferAggregator does not support getLong()");
    }

    @Override
    public void close() {
    }
}

