/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.Aggregators;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.cardinality.CardinalityAggregator;
import io.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;

public class CardinalityAggregatorFactory
implements AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 8;
    private final String name;
    private final List<String> fieldNames;
    private final boolean byRow;

    public static Object estimateCardinality(Object object) {
        if (object == null) {
            return 0;
        }
        return ((HyperLogLogCollector)object).estimateCardinality();
    }

    @JsonCreator
    public CardinalityAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="byRow") boolean byRow) {
        this.name = name;
        this.fieldNames = fieldNames;
        this.byRow = byRow;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory columnFactory) {
        List<DimensionSelector> selectors = this.makeDimensionSelectors(columnFactory);
        if (selectors.isEmpty()) {
            return Aggregators.noopAggregator();
        }
        return new CardinalityAggregator(this.name, selectors, this.byRow);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnFactory) {
        List<DimensionSelector> selectors = this.makeDimensionSelectors(columnFactory);
        if (selectors.isEmpty()) {
            return Aggregators.noopBufferAggregator();
        }
        return new CardinalityBufferAggregator(selectors, this.byRow);
    }

    private List<DimensionSelector> makeDimensionSelectors(final ColumnSelectorFactory columnFactory) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(this.fieldNames, (Function)new Function<String, DimensionSelector>(){

            @Nullable
            public DimensionSelector apply(@Nullable String input) {
                return columnFactory.makeDimensionSelector(input, null);
            }
        }), (Predicate)Predicates.notNull()));
    }

    @Override
    public Comparator getComparator() {
        return new Comparator<HyperLogLogCollector>(){

            @Override
            public int compare(HyperLogLogCollector lhs, HyperLogLogCollector rhs) {
                return lhs.compareTo(rhs);
            }
        };
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Lists.transform(this.fieldNames, (Function)new Function<String, AggregatorFactory>(){

            public AggregatorFactory apply(String input) {
                return new CardinalityAggregatorFactory(input, CardinalityAggregatorFactory.this.fieldNames, CardinalityAggregatorFactory.this.byRow);
            }
        });
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            return HyperLogLogCollector.makeCollector(ByteBuffer.wrap((byte[])object));
        }
        if (object instanceof ByteBuffer) {
            return HyperLogLogCollector.makeCollector((ByteBuffer)object);
        }
        if (object instanceof String) {
            return HyperLogLogCollector.makeCollector(ByteBuffer.wrap(Base64.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)))));
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return CardinalityAggregatorFactory.estimateCardinality(object);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldNames;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public boolean isByRow() {
        return this.byRow;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)Joiner.on((String)"\u0001").join(this.fieldNames));
        return ByteBuffer.allocate(2 + fieldNameBytes.length).put((byte)8).put(fieldNameBytes).put((byte)(this.byRow ? 1 : 0)).array();
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    @Override
    public Object getAggregatorStartValue() {
        return HyperLogLogCollector.makeLatestCollector();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardinalityAggregatorFactory that = (CardinalityAggregatorFactory)o;
        if (this.byRow != that.byRow) {
            return false;
        }
        if (this.fieldNames != null ? !this.fieldNames.equals(that.fieldNames) : that.fieldNames != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldNames != null ? this.fieldNames.hashCode() : 0);
        result = 31 * result + (this.byRow ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CardinalityAggregatorFactory{name='" + this.name + '\'' + ", fieldNames='" + this.fieldNames + '\'' + '}';
    }
}

