/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.primitives.Longs;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.Histogram;
import io.druid.segment.FloatColumnSelector;
import java.util.Comparator;

public class HistogramAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare((long)((Histogram)o).count, (long)((Histogram)o1).count);
        }
    };
    private final FloatColumnSelector selector;
    private final String name;
    private Histogram histogram;

    static Object combineHistograms(Object lhs, Object rhs) {
        return ((Histogram)lhs).fold((Histogram)rhs);
    }

    public HistogramAggregator(String name, FloatColumnSelector selector, float[] breaks) {
        this.name = name;
        this.selector = selector;
        this.histogram = new Histogram(breaks);
    }

    @Override
    public void aggregate() {
        this.histogram.offer(this.selector.get());
    }

    @Override
    public void reset() {
        this.histogram = new Histogram(this.histogram.breaks);
    }

    @Override
    public Object get() {
        return this.histogram;
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("HistogramAggregator does not support getFloat()");
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("HistogramAggregator does not support getLong()");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
    }
}

