/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.DoubleMaxAggregator;
import io.druid.query.aggregation.DoubleMaxBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DoubleMaxAggregatorFactory
implements AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 3;
    private final String fieldName;
    private final String name;

    @JsonCreator
    public DoubleMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new DoubleMaxAggregator(this.name, metricFactory.makeFloatColumnSelector(this.fieldName));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new DoubleMaxBufferAggregator(metricFactory.makeFloatColumnSelector(this.fieldName));
    }

    @Override
    public Comparator getComparator() {
        return DoubleMaxAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return DoubleMaxAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMaxAggregatorFactory(this.name, this.name);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new DoubleMaxAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)3).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        return "DoubleMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleMaxAggregatorFactory that = (DoubleMaxAggregatorFactory)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

