/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.segment.FloatColumnSelector;
import java.util.Comparator;

public class DoubleMaxAggregator
implements Aggregator {
    static final Comparator COMPARATOR = DoubleSumAggregator.COMPARATOR;
    private final FloatColumnSelector selector;
    private final String name;
    private double max;

    static double combineValues(Object lhs, Object rhs) {
        return Math.max(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    public DoubleMaxAggregator(String name, FloatColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.max = Math.max(this.max, (double)this.selector.get());
    }

    @Override
    public void reset() {
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public Object get() {
        return this.max;
    }

    @Override
    public float getFloat() {
        return (float)this.max;
    }

    @Override
    public long getLong() {
        return (long)this.max;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new DoubleMaxAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

