/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import java.util.Map;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final Iterable<QueryRunner> baseRunners;
    private final QueryToolChest<T, Query<T>> toolChest;

    public UnionQueryRunner(Iterable<QueryRunner> baseRunners, QueryToolChest<T, Query<T>> toolChest) {
        this.baseRunners = baseRunners;
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        if (Iterables.size(this.baseRunners) == 1) {
            return ((QueryRunner)Iterables.getOnlyElement(this.baseRunners)).run(query, responseContext);
        }
        return this.toolChest.mergeSequencesUnordered(Sequences.simple((Iterable)Iterables.transform(this.baseRunners, (Function)new Function<QueryRunner, Sequence<T>>(){

            public Sequence<T> apply(QueryRunner singleRunner) {
                return singleRunner.run(query, responseContext);
            }
        })));
    }
}

