/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.ResourceClosingSequence;
import com.metamx.common.guava.Sequence;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.segment.ReferenceCountingSegment;
import java.io.Closeable;
import java.util.Map;

public class ReferenceCountingSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunnerFactory<T, Query<T>> factory;
    private final ReferenceCountingSegment adapter;

    public ReferenceCountingSegmentQueryRunner(QueryRunnerFactory<T, Query<T>> factory, ReferenceCountingSegment adapter) {
        this.factory = factory;
        this.adapter = adapter;
    }

    @Override
    public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
        Closeable closeable = this.adapter.increment();
        try {
            Sequence<T> baseSequence = this.factory.createRunner(this.adapter).run(query, responseContext);
            return new ResourceClosingSequence(baseSequence, closeable);
        }
        catch (RuntimeException e) {
            CloseQuietly.close((Closeable)closeable);
            throw e;
        }
    }
}

