/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.io.IOException;
import java.util.Map;

public class MetricsEmittingQueryRunner<T>
implements QueryRunner<T> {
    private static final String DEFAULT_METRIC_NAME = "query/partial/time";
    private final ServiceEmitter emitter;
    private final Function<Query<T>, ServiceMetricEvent.Builder> builderFn;
    private final QueryRunner<T> queryRunner;
    private final long creationTime;
    private final String metricName;
    private final Map<String, String> userDimensions;

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner) {
        this(emitter, builderFn, queryRunner, DEFAULT_METRIC_NAME, Maps.newHashMap());
    }

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner, long creationTime, String metricName, Map<String, String> userDimensions) {
        this.emitter = emitter;
        this.builderFn = builderFn;
        this.queryRunner = queryRunner;
        this.creationTime = creationTime;
        this.metricName = metricName;
        this.userDimensions = userDimensions;
    }

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner, String metricName, Map<String, String> userDimensions) {
        this(emitter, builderFn, queryRunner, -1L, metricName, userDimensions);
    }

    public MetricsEmittingQueryRunner<T> withWaitMeasuredFromNow() {
        return new MetricsEmittingQueryRunner<T>(this.emitter, this.builderFn, this.queryRunner, System.currentTimeMillis(), this.metricName, this.userDimensions);
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        final ServiceMetricEvent.Builder builder = (ServiceMetricEvent.Builder)this.builderFn.apply(query);
        for (Map.Entry<String, String> userDimension : this.userDimensions.entrySet()) {
            builder.setDimension(userDimension.getKey(), userDimension.getValue());
        }
        builder.setDimension("id", Strings.nullToEmpty((String)query.getId()));
        return new Sequence<T>(){

            public <OutType> OutType accumulate(OutType outType, Accumulator<OutType, T> accumulator) {
                Object retVal;
                long startTime = System.currentTimeMillis();
                try {
                    retVal = MetricsEmittingQueryRunner.this.queryRunner.run(query, responseContext).accumulate(outType, accumulator);
                }
                catch (RuntimeException e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                catch (Error e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                finally {
                    long timeTaken = System.currentTimeMillis() - startTime;
                    MetricsEmittingQueryRunner.this.emitter.emit(builder.build(MetricsEmittingQueryRunner.this.metricName, (Number)timeTaken));
                    if (MetricsEmittingQueryRunner.this.creationTime > 0L) {
                        MetricsEmittingQueryRunner.this.emitter.emit(builder.build("query/wait/time", (Number)(startTime - MetricsEmittingQueryRunner.this.creationTime)));
                    }
                }
                return (OutType)retVal;
            }

            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                Yielder retVal;
                long startTime = System.currentTimeMillis();
                try {
                    retVal = MetricsEmittingQueryRunner.this.queryRunner.run(query, responseContext).toYielder(initValue, accumulator);
                }
                catch (RuntimeException e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                catch (Error e) {
                    builder.setDimension("status", "failed");
                    throw e;
                }
                return this.makeYielder(startTime, retVal, builder);
            }

            private <OutType> Yielder<OutType> makeYielder(final long startTime, final Yielder<OutType> yielder, final ServiceMetricEvent.Builder builder2) {
                return new Yielder<OutType>(){

                    public OutType get() {
                        return yielder.get();
                    }

                    public Yielder<OutType> next(OutType initValue) {
                        try {
                            return this.makeYielder(startTime, yielder.next(initValue), builder2);
                        }
                        catch (RuntimeException e) {
                            builder2.setDimension("status", "failed");
                            throw e;
                        }
                        catch (Error e) {
                            builder2.setDimension("status", "failed");
                            throw e;
                        }
                    }

                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws IOException {
                        try {
                            if (!this.isDone() && builder2.getDimension("status") == null) {
                                builder2.setDimension("status", "short");
                            }
                            long timeTaken = System.currentTimeMillis() - startTime;
                            MetricsEmittingQueryRunner.this.emitter.emit(builder2.build(MetricsEmittingQueryRunner.this.metricName, (Number)timeTaken));
                            if (MetricsEmittingQueryRunner.this.creationTime > 0L) {
                                MetricsEmittingQueryRunner.this.emitter.emit(builder2.build("query/wait/time", (Number)(startTime - MetricsEmittingQueryRunner.this.creationTime)));
                            }
                        }
                        finally {
                            yielder.close();
                        }
                    }
                };
            }
        };
    }
}

