/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import com.metamx.common.guava.Sequence;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;

public abstract class BaseQuery<T>
implements Query<T> {
    public static final String QUERYID = "queryId";
    private final DataSource dataSource;
    private final Map<String, Object> context;
    private final QuerySegmentSpec querySegmentSpec;
    private volatile Duration duration;

    public BaseQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, Map<String, Object> context) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource can't be null");
        Preconditions.checkNotNull((Object)querySegmentSpec, (Object)"querySegmentSpec can't be null");
        this.dataSource = dataSource;
        this.context = context;
        this.querySegmentSpec = querySegmentSpec;
    }

    @Override
    @JsonProperty
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="intervals")
    public QuerySegmentSpec getQuerySegmentSpec() {
        return this.querySegmentSpec;
    }

    @Override
    public Sequence<T> run(QuerySegmentWalker walker, Map<String, Object> context) {
        return this.run(this.querySegmentSpec.lookup(this, walker), context);
    }

    @Override
    public Sequence<T> run(QueryRunner<T> runner, Map<String, Object> context) {
        return runner.run(this, context);
    }

    @Override
    public List<Interval> getIntervals() {
        return this.querySegmentSpec.getIntervals();
    }

    @Override
    public Duration getDuration() {
        if (this.duration == null) {
            Duration totalDuration = new Duration(0L);
            for (Interval interval : this.querySegmentSpec.getIntervals()) {
                if (interval == null) continue;
                totalDuration = totalDuration.plus((ReadableDuration)interval.toDuration());
            }
            this.duration = totalDuration;
        }
        return this.duration;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public <ContextType> ContextType getContextValue(String key) {
        return (ContextType)(this.context == null ? null : this.context.get(key));
    }

    @Override
    public <ContextType> ContextType getContextValue(String key, ContextType defaultValue) {
        ContextType retVal = this.getContextValue(key);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public int getContextPriority(int defaultValue) {
        if (this.context == null) {
            return defaultValue;
        }
        Object val = this.context.get("priority");
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof String) {
            return Integer.parseInt((String)val);
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        throw new ISE("Unknown type [%s]", new Object[]{val.getClass()});
    }

    @Override
    public boolean getContextBySegment(boolean defaultValue) {
        return this.parseBoolean("bySegment", defaultValue);
    }

    @Override
    public boolean getContextPopulateCache(boolean defaultValue) {
        return this.parseBoolean("populateCache", defaultValue);
    }

    @Override
    public boolean getContextUseCache(boolean defaultValue) {
        return this.parseBoolean("useCache", defaultValue);
    }

    @Override
    public boolean getContextFinalize(boolean defaultValue) {
        return this.parseBoolean("finalize", defaultValue);
    }

    private boolean parseBoolean(String key, boolean defaultValue) {
        if (this.context == null) {
            return defaultValue;
        }
        Object val = this.context.get(key);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        throw new ISE("Unknown type [%s]. Cannot parse!", new Object[]{val.getClass()});
    }

    protected Map<String, Object> computeOverridenContext(Map<String, Object> overrides) {
        TreeMap overridden = Maps.newTreeMap();
        Map<String, Object> context = this.getContext();
        if (context != null) {
            overridden.putAll(context);
        }
        overridden.putAll(overrides);
        return overridden;
    }

    @Override
    public String getId() {
        return (String)this.getContextValue(QUERYID);
    }

    @Override
    public Query withId(String id) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)QUERYID, (Object)id));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseQuery baseQuery = (BaseQuery)o;
        if (this.context != null ? !this.context.equals(baseQuery.context) : baseQuery.context != null) {
            return false;
        }
        if (this.dataSource != null ? !this.dataSource.equals(baseQuery.dataSource) : baseQuery.dataSource != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals((Object)baseQuery.duration) : baseQuery.duration != null) {
            return false;
        }
        return !(this.querySegmentSpec != null ? !this.querySegmentSpec.equals(baseQuery.querySegmentSpec) : baseQuery.querySegmentSpec != null);
    }

    public int hashCode() {
        int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.querySegmentSpec != null ? this.querySegmentSpec.hashCode() : 0);
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        return result;
    }
}

