/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.guava.LazySequence;
import com.metamx.common.guava.Sequence;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final ListeningExecutorService executor;
    private final QueryWatcher queryWatcher;

    public AsyncQueryRunner(QueryRunner<T> baseRunner, ExecutorService executor, QueryWatcher queryWatcher) {
        this.baseRunner = baseRunner;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> responseContext) {
        int priority = query.getContextPriority(0);
        final ListenableFuture future = this.executor.submit((Callable)new AbstractPrioritizedCallable<Sequence<T>>(priority){

            @Override
            public Sequence<T> call() throws Exception {
                return AsyncQueryRunner.this.baseRunner.run(query, responseContext);
            }
        });
        this.queryWatcher.registerQuery(query, future);
        return new LazySequence(new Supplier<Sequence<T>>(){

            public Sequence<T> get() {
                try {
                    Number timeout = (Number)query.getContextValue("timeout");
                    if (timeout == null) {
                        return (Sequence)future.get();
                    }
                    return (Sequence)future.get(timeout.longValue(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        });
    }
}

