/*
 * Decompiled with CFR 0.152.
 */
package io.druid.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.metamx.common.IAE;
import io.druid.granularity.AllGranularity;
import io.druid.granularity.DurationGranularity;
import io.druid.granularity.NoneGranularity;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;

public abstract class QueryGranularity {
    public static final QueryGranularity ALL = new AllGranularity();
    public static final QueryGranularity NONE = new NoneGranularity();
    public static final QueryGranularity MINUTE = QueryGranularity.fromString("MINUTE");
    public static final QueryGranularity HOUR = QueryGranularity.fromString("HOUR");
    public static final QueryGranularity DAY = QueryGranularity.fromString("DAY");
    public static final QueryGranularity SECOND = QueryGranularity.fromString("SECOND");

    public abstract long next(long var1);

    public abstract long truncate(long var1);

    public abstract byte[] cacheKey();

    public abstract DateTime toDateTime(long var1);

    public abstract Iterable<Long> iterable(long var1, long var3);

    @JsonCreator
    public static QueryGranularity fromString(String str) {
        String name = str.toUpperCase();
        if (name.equals("ALL")) {
            return ALL;
        }
        if (name.equals("NONE")) {
            return NONE;
        }
        return new DurationGranularity(QueryGranularity.convertValue(str), 0L);
    }

    private static long convertValue(Object o) {
        if (o instanceof String) {
            return MillisIn.valueOf(((String)o).toUpperCase()).millis;
        }
        if (o instanceof ReadableDuration) {
            return ((ReadableDuration)o).getMillis();
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new IAE("Cannot convert [%s] to QueryGranularity", new Object[]{o.getClass()});
    }

    private static enum MillisIn {
        SECOND(1000L),
        MINUTE(60000L),
        FIFTEEN_MINUTE(900000L),
        THIRTY_MINUTE(1800000L),
        HOUR(3600000L),
        DAY(86400000L);

        private final long millis;

        private MillisIn(long millis) {
            this.millis = millis;
        }
    }
}

