/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.IAE;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerde;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferSerializer;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    private final boolean isSingleValued;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final GenericIndexed<String> dictionary;
    private final VSizeIndexedInts singleValuedColumn;
    private final VSizeIndexed multiValuedColumn;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final ImmutableRTree spatialIndex;
    private final long size;

    public DictionaryEncodedColumnPartSerde(GenericIndexed<String> dictionary, VSizeIndexedInts singleValCol, VSizeIndexed multiValCol, BitmapSerdeFactory bitmapSerdeFactory, GenericIndexed<ImmutableBitmap> bitmaps, ImmutableRTree spatialIndex) {
        this.isSingleValued = multiValCol == null;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValCol;
        this.multiValuedColumn = multiValCol;
        this.bitmaps = bitmaps;
        this.spatialIndex = spatialIndex;
        long size = dictionary.getSerializedSize();
        if (singleValCol != null && multiValCol == null) {
            size += (long)singleValCol.getSerializedSize();
        } else if (singleValCol == null && multiValCol != null) {
            size += (long)multiValCol.getSerializedSize();
        } else {
            throw new IAE("Either singleValCol[%s] or multiValCol[%s] must be set", new Object[]{singleValCol, multiValCol});
        }
        size += bitmaps.getSerializedSize();
        if (spatialIndex != null) {
            size += (long)(spatialIndex.size() + 4);
        }
        this.size = size;
    }

    @JsonCreator
    public DictionaryEncodedColumnPartSerde(@JsonProperty(value="isSingleValued") boolean isSingleValued, @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory) {
        this.isSingleValued = isSingleValued;
        this.bitmapSerdeFactory = bitmapSerdeFactory == null ? new BitmapSerde.LegacyBitmapSerdeFactory() : bitmapSerdeFactory;
        this.dictionary = null;
        this.singleValuedColumn = null;
        this.multiValuedColumn = null;
        this.bitmaps = null;
        this.spatialIndex = null;
        this.size = 0L;
    }

    @JsonProperty
    private boolean isSingleValued() {
        return this.isSingleValued;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @Override
    public long numBytes() {
        return 1L + this.size;
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{(byte)(!this.isSingleValued ? 1 : 0)}));
        if (this.dictionary != null) {
            this.dictionary.writeToChannel(channel);
        }
        if (this.isSingleValued()) {
            if (this.singleValuedColumn != null) {
                this.singleValuedColumn.writeToChannel(channel);
            }
        } else if (this.multiValuedColumn != null) {
            this.multiValuedColumn.writeToChannel(channel);
        }
        if (this.bitmaps != null) {
            this.bitmaps.writeToChannel(channel);
        }
        if (this.spatialIndex != null) {
            ByteBufferSerializer.writeToChannel(this.spatialIndex, new IndexedRTree.ImmutableRTreeObjectStrategy(this.bitmapSerdeFactory.getBitmapFactory()), channel);
        }
    }

    @Override
    public ColumnPartSerde read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        VSizeIndexed multiValuedColumn;
        VSizeIndexedInts singleValuedColumn;
        boolean isSingleValued = buffer.get() == 0;
        GenericIndexed<String> dictionary = GenericIndexed.read(buffer, GenericIndexed.stringStrategy);
        builder.setType(ValueType.STRING);
        if (isSingleValued) {
            singleValuedColumn = VSizeIndexedInts.readFromByteBuffer(buffer);
            multiValuedColumn = null;
            builder.setHasMultipleValues(false).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(dictionary, singleValuedColumn, null, columnConfig.columnCacheSizeBytes()));
        } else {
            singleValuedColumn = null;
            multiValuedColumn = VSizeIndexed.readFromByteBuffer(buffer);
            builder.setHasMultipleValues(true).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(dictionary, null, multiValuedColumn, columnConfig.columnCacheSizeBytes()));
        }
        GenericIndexed<ImmutableBitmap> bitmaps = GenericIndexed.read(buffer, this.bitmapSerdeFactory.getObjectStrategy());
        builder.setBitmapIndex(new BitmapIndexColumnPartSupplier(this.bitmapSerdeFactory.getBitmapFactory(), bitmaps, dictionary));
        ImmutableRTree spatialIndex = null;
        if (buffer.hasRemaining()) {
            spatialIndex = ByteBufferSerializer.read(buffer, new IndexedRTree.ImmutableRTreeObjectStrategy(this.bitmapSerdeFactory.getBitmapFactory()));
            builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(spatialIndex));
        }
        return new DictionaryEncodedColumnPartSerde(dictionary, singleValuedColumn, multiValuedColumn, this.bitmapSerdeFactory, bitmaps, spatialIndex);
    }
}

