/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ComplexColumnPartSerde
implements ColumnPartSerde {
    private final GenericIndexed column;
    private final String typeName;
    private final ComplexMetricSerde serde;

    @JsonCreator
    public static ComplexColumnPartSerde createDeserializer(@JsonProperty(value="typeName") String complexType) {
        return new ComplexColumnPartSerde(null, complexType);
    }

    public ComplexColumnPartSerde(GenericIndexed column, String typeName) {
        this.column = column;
        this.typeName = typeName;
        this.serde = ComplexMetrics.getSerdeForType(typeName);
    }

    @JsonProperty
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public long numBytes() {
        return this.column.getSerializedSize();
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        this.column.writeToChannel(channel);
    }

    @Override
    public ColumnPartSerde read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        return this.serde == null ? this : this.serde.deserializeColumn(buffer, builder);
    }
}

