/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.metamx.common.ISE;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import io.druid.data.input.InputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mapdb.Store;

public class OffheapIncrementalIndex
extends IncrementalIndex<BufferAggregator> {
    private static final long STORE_CHUNK_SIZE;
    private final ResourceHolder<ByteBuffer> bufferHolder;
    private final DB db;
    private final DB factsDb;
    private final int[] aggPositionOffsets;
    private final int totalAggSize;
    private final ConcurrentNavigableMap<IncrementalIndex.TimeAndDims, Integer> facts;
    private final int maxTotalBufferSize;
    private String outOfRowsReason = null;

    public OffheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, StupidPool<ByteBuffer> bufferPool, boolean deserializeComplexMetrics, int maxTotalBufferSize) {
        super(incrementalIndexSchema, deserializeComplexMetrics);
        this.bufferHolder = bufferPool.take();
        Preconditions.checkArgument((maxTotalBufferSize > ((ByteBuffer)this.bufferHolder.get()).limit() ? 1 : 0) != 0, (Object)"Maximum total buffer size must be greater than aggregation buffer size");
        AggregatorFactory[] metrics = incrementalIndexSchema.getMetrics();
        this.aggPositionOffsets = new int[metrics.length];
        int currAggSize = 0;
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            this.aggPositionOffsets[i] = currAggSize;
            currAggSize += agg.getMaxIntermediateSize();
        }
        this.totalAggSize = currAggSize;
        DBMaker dbMaker = DBMaker.newMemoryDirectDB().transactionDisable().asyncWriteEnable().cacheLRUEnable().cacheSize(16384);
        this.factsDb = dbMaker.make();
        this.db = dbMaker.make();
        TimeAndDimsSerializer timeAndDimsSerializer = new TimeAndDimsSerializer(this);
        this.facts = this.factsDb.createTreeMap("__facts" + UUID.randomUUID()).keySerializer((BTreeKeySerializer)timeAndDimsSerializer).comparator(timeAndDimsSerializer.getComparator()).valueSerializer(Serializer.INTEGER).make();
        this.maxTotalBufferSize = maxTotalBufferSize;
    }

    public OffheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, StupidPool<ByteBuffer> bufferPool, boolean deserializeComplexMetrics, int maxTotalBufferSize) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).build(), bufferPool, deserializeComplexMetrics, maxTotalBufferSize);
    }

    @Override
    public ConcurrentNavigableMap<IncrementalIndex.TimeAndDims, Integer> getFacts() {
        return this.facts;
    }

    @Override
    protected IncrementalIndex.DimDim makeDimDim(String dimension) {
        return new OffheapDimDim(dimension);
    }

    protected BufferAggregator[] initAggs(AggregatorFactory[] metrics, ThreadLocal<InputRow> in, boolean deserializeComplexMetrics) {
        BufferAggregator[] aggs = new BufferAggregator[metrics.length];
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            aggs[i] = agg.factorizeBuffered(OffheapIncrementalIndex.makeColumnSelectorFactory(agg, in, deserializeComplexMetrics));
        }
        return aggs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> in) throws IndexSizeExceededException {
        Integer rowOffset;
        BufferAggregator[] aggs = (BufferAggregator[])this.getAggs();
        OffheapIncrementalIndex offheapIncrementalIndex = this;
        synchronized (offheapIncrementalIndex) {
            if (!this.facts.containsKey(key) && !this.canAppendRow(false)) {
                throw new IndexSizeExceededException(this.getOutOfRowsReason());
            }
            rowOffset = this.totalAggSize * numEntries.get();
            Integer prev = this.facts.putIfAbsent(key, rowOffset);
            if (prev != null) {
                rowOffset = prev;
            } else {
                numEntries.incrementAndGet();
                for (int i = 0; i < aggs.length; ++i) {
                    aggs[i].init((ByteBuffer)this.bufferHolder.get(), this.getMetricPosition(rowOffset, i));
                }
            }
        }
        in.set(row);
        for (int i = 0; i < aggs.length; ++i) {
            BufferAggregator bufferAggregator = aggs[i];
            synchronized (bufferAggregator) {
                aggs[i].aggregate((ByteBuffer)this.bufferHolder.get(), this.getMetricPosition(rowOffset, i));
                continue;
            }
        }
        in.set(null);
        return numEntries.get();
    }

    @Override
    public boolean canAppendRow() {
        return this.canAppendRow(true);
    }

    private boolean canAppendRow(boolean includeFudgeFactor) {
        int aggBufferSize = ((ByteBuffer)this.bufferHolder.get()).limit();
        if ((this.size() + 1) * this.totalAggSize > aggBufferSize) {
            this.outOfRowsReason = String.format("Maximum aggregation buffer limit reached [%d bytes].", aggBufferSize);
            return false;
        }
        if (this.getCurrentSize() + (long)this.totalAggSize + 2L * STORE_CHUNK_SIZE + (includeFudgeFactor ? STORE_CHUNK_SIZE : 0L) > (long)this.maxTotalBufferSize) {
            this.outOfRowsReason = String.format("Maximum time and dimension buffer limit reached [%d bytes].", this.maxTotalBufferSize - aggBufferSize);
            return false;
        }
        return true;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected BufferAggregator[] getAggsForRow(int rowOffset) {
        return (BufferAggregator[])this.getAggs();
    }

    @Override
    protected Object getAggVal(BufferAggregator agg, int rowOffset, int aggPosition) {
        return agg.get((ByteBuffer)this.bufferHolder.get(), this.getMetricPosition(rowOffset, aggPosition));
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return ((BufferAggregator[])this.getAggs())[aggOffset].getFloat((ByteBuffer)this.bufferHolder.get(), this.getMetricPosition(rowOffset, aggOffset));
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return ((BufferAggregator[])this.getAggs())[aggOffset].getLong((ByteBuffer)this.bufferHolder.get(), this.getMetricPosition(rowOffset, aggOffset));
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return ((BufferAggregator[])this.getAggs())[aggOffset].get((ByteBuffer)this.bufferHolder.get(), this.getMetricPosition(rowOffset, aggOffset));
    }

    @Override
    public void close() {
        try {
            this.bufferHolder.close();
            Store.forDB((DB)this.db).close();
            Store.forDB((DB)this.factsDb).close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private int getMetricPosition(int rowOffset, int metricIndex) {
        return rowOffset + this.aggPositionOffsets[metricIndex];
    }

    private IncrementalIndex.DimDim getDimDim(int dimIndex) {
        return this.getDimValues().get(this.getDimensions().get(dimIndex));
    }

    private long getCurrentSize() {
        return Store.forDB((DB)this.db).getCurrSize() + Store.forDB((DB)this.factsDb).getCurrSize() + (long)(this.size() * this.totalAggSize);
    }

    static {
        try {
            Field field = Store.class.getDeclaredField("CHUNK_SIZE");
            field.setAccessible(true);
            STORE_CHUNK_SIZE = field.getLong(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to determine MapDB store chunk size", e);
        }
    }

    private class OffheapDimDim
    implements IncrementalIndex.DimDim {
        private final Map<String, Integer> falseIds;
        private final Map<Integer, String> falseIdsReverse;
        private final WeakHashMap<String, WeakReference<String>> cache = new WeakHashMap();
        private volatile String[] sortedVals = null;
        private volatile int size = 0;

        public OffheapDimDim(String dimension) {
            this.falseIds = OffheapIncrementalIndex.this.db.createHashMap(dimension).keySerializer(Serializer.STRING).valueSerializer(Serializer.INTEGER).make();
            this.falseIdsReverse = OffheapIncrementalIndex.this.db.createHashMap(dimension + "_inverse").keySerializer(Serializer.INTEGER).valueSerializer(Serializer.STRING).make();
        }

        @Override
        public String get(String str) {
            String value;
            WeakReference<String> cached = this.cache.get(str);
            if (cached != null && (value = (String)cached.get()) != null) {
                return value;
            }
            this.cache.put(str, new WeakReference<String>(str));
            return str;
        }

        @Override
        public int getId(String value) {
            return this.falseIds.get(value);
        }

        @Override
        public String getValue(int id) {
            return this.falseIdsReverse.get(id);
        }

        @Override
        public boolean contains(String value) {
            return this.falseIds.containsKey(value);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public synchronized int add(String value) {
            int id = this.size++;
            this.falseIds.put(value, id);
            this.falseIdsReverse.put(id, value);
            return id;
        }

        @Override
        public int getSortedId(String value) {
            this.assertSorted();
            return Arrays.binarySearch(this.sortedVals, value);
        }

        @Override
        public String getSortedValue(int index) {
            this.assertSorted();
            return this.sortedVals[index];
        }

        @Override
        public void sort() {
            if (this.sortedVals == null) {
                this.sortedVals = new String[this.falseIds.size()];
                int index = 0;
                for (String value : this.falseIds.keySet()) {
                    this.sortedVals[index++] = value;
                }
                Arrays.sort(this.sortedVals);
            }
        }

        private void assertSorted() {
            if (this.sortedVals == null) {
                throw new ISE("Call sort() before calling the getSorted* methods.", new Object[0]);
            }
        }

        @Override
        public boolean compareCannonicalValues(String s1, String s2) {
            return s1.equals(s2);
        }
    }

    private static class TimeAndDimsComparator
    implements Comparator,
    Serializable {
        private TimeAndDimsComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((IncrementalIndex.TimeAndDims)o1).compareTo((IncrementalIndex.TimeAndDims)o2);
        }
    }

    private static class TimeAndDimsSerializer
    extends BTreeKeySerializer<IncrementalIndex.TimeAndDims>
    implements Serializable {
        private final TimeAndDimsComparator comparator = new TimeAndDimsComparator();
        private final transient OffheapIncrementalIndex incrementalIndex;

        TimeAndDimsSerializer(OffheapIncrementalIndex incrementalIndex) {
            this.incrementalIndex = incrementalIndex;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                IncrementalIndex.TimeAndDims timeAndDim = (IncrementalIndex.TimeAndDims)keys[i];
                out.writeLong(timeAndDim.getTimestamp());
                out.writeInt(timeAndDim.getDims().length);
                int index = 0;
                for (String[] dims : timeAndDim.getDims()) {
                    if (dims == null) {
                        out.write(-1);
                    } else {
                        IncrementalIndex.DimDim dimDim = this.incrementalIndex.getDimDim(index);
                        out.writeInt(dims.length);
                        for (String value : dims) {
                            out.writeInt(dimDim.getId(value));
                        }
                    }
                    ++index;
                }
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                long timeStamp = in.readLong();
                String[][] dims = new String[in.readInt()][];
                for (int k = 0; k < dims.length; ++k) {
                    int len = in.readInt();
                    if (len == -1) continue;
                    IncrementalIndex.DimDim dimDim = this.incrementalIndex.getDimDim(k);
                    String[] col = new String[len];
                    for (int l = 0; l < col.length; ++l) {
                        col[l] = dimDim.get(dimDim.getValue(in.readInt()));
                    }
                    dims[k] = col;
                }
                ret[i] = new IncrementalIndex.TimeAndDims(timeStamp, dims);
            }
            return ret;
        }

        public Comparator<IncrementalIndex.TimeAndDims> getComparator() {
            return this.comparator;
        }
    }
}

