/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;

public class IncrementalIndexSchema {
    private final long minTimestamp;
    private final QueryGranularity gran;
    private final DimensionsSpec dimensionsSpec;
    private final AggregatorFactory[] metrics;

    public IncrementalIndexSchema(long minTimestamp, QueryGranularity gran, DimensionsSpec dimensionsSpec, AggregatorFactory[] metrics) {
        this.minTimestamp = minTimestamp;
        this.gran = gran;
        this.dimensionsSpec = dimensionsSpec;
        this.metrics = metrics;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public QueryGranularity getGran() {
        return this.gran;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public AggregatorFactory[] getMetrics() {
        return this.metrics;
    }

    public static class Builder {
        private long minTimestamp = 0L;
        private QueryGranularity gran = QueryGranularity.NONE;
        private DimensionsSpec dimensionsSpec = new DimensionsSpec(null, null, null);
        private AggregatorFactory[] metrics = new AggregatorFactory[0];

        public Builder withMinTimestamp(long minTimestamp) {
            this.minTimestamp = minTimestamp;
            return this;
        }

        public Builder withQueryGranularity(QueryGranularity gran) {
            this.gran = gran;
            return this;
        }

        public Builder withDimensionsSpec(DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder withDimensionsSpec(InputRowParser parser) {
            this.dimensionsSpec = parser != null && parser.getParseSpec() != null && parser.getParseSpec().getDimensionsSpec() != null ? parser.getParseSpec().getDimensionsSpec() : new DimensionsSpec(null, null, null);
            return this;
        }

        public Builder withMetrics(AggregatorFactory[] metrics) {
            this.metrics = metrics;
            return this;
        }

        public IncrementalIndexSchema build() {
            return new IncrementalIndexSchema(this.minTimestamp, this.gran, this.dimensionsSpec, this.metrics);
        }
    }
}

