/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.collect.Lists;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.WrappedConciseBitmap;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.OrFilter;
import io.druid.segment.filter.SelectorFilter;
import java.util.ArrayList;
import java.util.List;

public class ExtractionFilter
implements Filter {
    private final String dimension;
    private final String value;
    private final ExtractionFn fn;

    public ExtractionFilter(String dimension, String value, ExtractionFn fn) {
        this.dimension = dimension;
        this.value = value;
        this.fn = fn;
    }

    private List<Filter> makeFilters(BitmapIndexSelector selector) {
        Indexed<String> allDimVals = selector.getDimensionValues(this.dimension);
        ArrayList filters = Lists.newArrayList();
        if (allDimVals != null) {
            for (int i = 0; i < allDimVals.size(); ++i) {
                String dimVal = allDimVals.get(i);
                if (!this.value.equals(this.fn.apply(dimVal))) continue;
                filters.add(new SelectorFilter(this.dimension, dimVal));
            }
        }
        return filters;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        List<Filter> filters = this.makeFilters(selector);
        if (filters.isEmpty()) {
            return new WrappedConciseBitmap();
        }
        return new OrFilter(this.makeFilters(selector)).getBitmapIndex(selector);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        throw new UnsupportedOperationException();
    }
}

