/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.guava.FunctionalIterable;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.data.Indexed;
import javax.annotation.Nullable;

class DimensionPredicateFilter
implements Filter {
    private final String dimension;
    private final Predicate<String> predicate;

    public DimensionPredicateFilter(String dimension, Predicate<String> predicate) {
        this.dimension = dimension;
        this.predicate = predicate;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(final BitmapIndexSelector selector) {
        Indexed<String> dimValues = selector.getDimensionValues(this.dimension);
        if (dimValues == null || dimValues.size() == 0 || this.predicate == null) {
            return selector.getBitmapFactory().makeEmptyImmutableBitmap();
        }
        return selector.getBitmapFactory().union((Iterable)FunctionalIterable.create(dimValues).filter(this.predicate).transform((Function)new Function<String, ImmutableBitmap>(){

            public ImmutableBitmap apply(@Nullable String input) {
                return selector.getBitmapIndex(DimensionPredicateFilter.this.dimension, input);
            }
        }));
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicate);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        throw new UnsupportedOperationException();
    }
}

