/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.WrappedImmutableConciseBitmap;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ObjectStrategy;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.nio.ByteBuffer;

public class ConciseBitmapSerdeFactory
implements BitmapSerdeFactory {
    private static final ObjectStrategy<ImmutableBitmap> objectStrategy = new ImmutableConciseSetObjectStrategy();
    private static final BitmapFactory bitmapFactory = new ConciseBitmapFactory();
    private static Ordering<WrappedImmutableConciseBitmap> conciseComparator = new Ordering<WrappedImmutableConciseBitmap>(){

        public int compare(WrappedImmutableConciseBitmap conciseSet, WrappedImmutableConciseBitmap conciseSet1) {
            if (conciseSet.size() == 0 && conciseSet1.size() == 0) {
                return 0;
            }
            if (conciseSet.size() == 0) {
                return -1;
            }
            if (conciseSet1.size() == 0) {
                return 1;
            }
            return conciseSet.compareTo((ImmutableBitmap)conciseSet1);
        }
    }.nullsFirst();

    @Override
    public ObjectStrategy<ImmutableBitmap> getObjectStrategy() {
        return objectStrategy;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return bitmapFactory;
    }

    private static class ImmutableConciseSetObjectStrategy
    implements ObjectStrategy<ImmutableBitmap> {
        private ImmutableConciseSetObjectStrategy() {
        }

        @Override
        public Class<ImmutableBitmap> getClazz() {
            return ImmutableBitmap.class;
        }

        @Override
        public WrappedImmutableConciseBitmap fromByteBuffer(ByteBuffer buffer, int numBytes) {
            ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
            readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
            return new WrappedImmutableConciseBitmap(new ImmutableConciseSet(readOnlyBuffer));
        }

        @Override
        public byte[] toBytes(ImmutableBitmap val) {
            if (val == null || val.size() == 0) {
                return new byte[0];
            }
            return val.toBytes();
        }

        @Override
        public int compare(ImmutableBitmap o1, ImmutableBitmap o2) {
            return conciseComparator.compare((Object)((WrappedImmutableConciseBitmap)o1), (Object)((WrappedImmutableConciseBitmap)o2));
        }
    }
}

