/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.FixedSizeCompressedObjectStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class CompressedFloatBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<FloatBuffer> {
    public static CompressedFloatBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedFloatBufferObjectStrategy(order, compression, sizePer);
    }

    private CompressedFloatBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<FloatBuffer>(){

            @Override
            public FloatBuffer convert(ByteBuffer buf) {
                return buf.asFloatBuffer();
            }

            @Override
            public int compare(FloatBuffer lhs, FloatBuffer rhs) {
                return Ordering.natural().nullsFirst().compare((Object)lhs, (Object)rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 4;
            }

            @Override
            public FloatBuffer combine(ByteBuffer into, FloatBuffer from) {
                return into.asFloatBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

