/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.segment.data.IndexedInts;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.roaringbitmap.IntIterator;

public class BitmapCompressedIndexedInts
implements IndexedInts,
Comparable<ImmutableBitmap> {
    private static Ordering<ImmutableBitmap> comparator = new Ordering<ImmutableBitmap>(){

        public int compare(ImmutableBitmap set, ImmutableBitmap set1) {
            if (set.size() == 0 && set1.size() == 0) {
                return 0;
            }
            if (set.size() == 0) {
                return -1;
            }
            if (set1.size() == 0) {
                return 1;
            }
            return set.compareTo(set1);
        }
    }.nullsFirst();
    private final ImmutableBitmap immutableBitmap;

    public BitmapCompressedIndexedInts(ImmutableBitmap immutableBitmap) {
        this.immutableBitmap = immutableBitmap;
    }

    @Override
    public int compareTo(@Nullable ImmutableBitmap otherBitmap) {
        return comparator.compare((Object)this.immutableBitmap, (Object)otherBitmap);
    }

    @Override
    public int size() {
        return this.immutableBitmap.size();
    }

    @Override
    public int get(int index) {
        throw new UnsupportedOperationException("This is really slow, so it's just not supported.");
    }

    public ImmutableBitmap getImmutableBitmap() {
        return this.immutableBitmap;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            IntIterator baseIterator;
            {
                this.baseIterator = BitmapCompressedIndexedInts.this.immutableBitmap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.baseIterator.hasNext();
            }

            @Override
            public Integer next() {
                return this.baseIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

