/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.Offset;

public class ArrayBasedOffset
implements Offset {
    private final int[] ints;
    private int currIndex;

    public ArrayBasedOffset(int[] ints) {
        this(ints, 0);
    }

    public ArrayBasedOffset(int[] ints, int startIndex) {
        this.ints = ints;
        this.currIndex = startIndex;
    }

    @Override
    public int getOffset() {
        return this.ints[this.currIndex];
    }

    @Override
    public void increment() {
        ++this.currIndex;
    }

    @Override
    public boolean withinBounds() {
        return this.currIndex < this.ints.length;
    }

    @Override
    public Offset clone() {
        ArrayBasedOffset retVal = new ArrayBasedOffset(this.ints);
        retVal.currIndex = this.currIndex;
        return retVal;
    }
}

