/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.data.CachingIndexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import java.io.IOException;

public class SimpleDictionaryEncodedColumn
implements DictionaryEncodedColumn {
    private final VSizeIndexedInts column;
    private final VSizeIndexed multiValueColumn;
    private final CachingIndexed<String> cachedLookups;

    public SimpleDictionaryEncodedColumn(VSizeIndexedInts singleValueColumn, VSizeIndexed multiValueColumn, CachingIndexed<String> cachedLookups) {
        this.column = singleValueColumn;
        this.multiValueColumn = multiValueColumn;
        this.cachedLookups = cachedLookups;
    }

    @Override
    public int length() {
        return this.hasMultipleValues() ? this.multiValueColumn.size() : this.column.size();
    }

    @Override
    public boolean hasMultipleValues() {
        return this.column == null;
    }

    @Override
    public int getSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedInts getMultiValueRow(int rowNum) {
        return this.multiValueColumn.get(rowNum);
    }

    @Override
    public String lookupName(int id) {
        return this.cachedLookups.get(id);
    }

    @Override
    public int lookupId(String name) {
        return this.cachedLookups.indexOf(name);
    }

    @Override
    public int getCardinality() {
        return this.cachedLookups.size();
    }

    @Override
    public void close() throws IOException {
        this.cachedLookups.close();
    }
}

