/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.joda.time.DateTime;

public class Rowboat
implements Comparable<Rowboat> {
    private final long timestamp;
    private final int[][] dims;
    private final Object[] metrics;
    private final int rowNum;
    private final Map<Integer, TreeSet<Integer>> comprisedRows;

    public Rowboat(long timestamp, int[][] dims, Object[] metrics, int rowNum) {
        this.timestamp = timestamp;
        this.dims = dims;
        this.metrics = metrics;
        this.rowNum = rowNum;
        this.comprisedRows = Maps.newHashMap();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int[][] getDims() {
        return this.dims;
    }

    public Object[] getMetrics() {
        return this.metrics;
    }

    public void addRow(int indexNum, int rowNum) {
        TreeSet rowNums = this.comprisedRows.get(indexNum);
        if (rowNums == null) {
            rowNums = Sets.newTreeSet();
            this.comprisedRows.put(indexNum, rowNums);
        }
        rowNums.add(rowNum);
    }

    public Map<Integer, TreeSet<Integer>> getComprisedRows() {
        return this.comprisedRows;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public int compareTo(Rowboat rhs) {
        int retVal = Longs.compare((long)this.timestamp, (long)rhs.timestamp);
        if (retVal == 0) {
            retVal = Ints.compare((int)this.dims.length, (int)rhs.dims.length);
        }
        int index = 0;
        while (retVal == 0 && index < this.dims.length) {
            int[] lhsVals = this.dims[index];
            int[] rhsVals = rhs.dims[index];
            if (lhsVals == null) {
                if (rhsVals == null) {
                    ++index;
                    continue;
                }
                return -1;
            }
            if (rhsVals == null) {
                return 1;
            }
            retVal = Ints.compare((int)lhsVals.length, (int)rhsVals.length);
            for (int valsIndex = 0; retVal == 0 && valsIndex < lhsVals.length; ++valsIndex) {
                retVal = Ints.compare((int)lhsVals[valsIndex], (int)rhsVals[valsIndex]);
            }
            ++index;
        }
        return retVal;
    }

    public String toString() {
        return "Rowboat{timestamp=" + new DateTime(this.timestamp).toString() + ", dims=" + (this.dims == null ? null : Arrays.asList(this.dims)) + ", metrics=" + (this.metrics == null ? null : Arrays.asList(this.metrics)) + ", comprisedRows=" + this.comprisedRows + '}';
    }
}

