/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.io.smoosh.FileSmoosher;
import com.metamx.common.io.smoosh.Smoosh;
import com.metamx.common.io.smoosh.SmooshedFileMapper;
import com.metamx.common.io.smoosh.SmooshedWriter;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.EmittingLogger;
import io.druid.common.utils.SerializerUtils;
import io.druid.guice.ConfigProvider;
import io.druid.guice.GuiceInjectors;
import io.druid.guice.JsonConfigProvider;
import io.druid.query.DruidProcessingConfig;
import io.druid.segment.IndexMerger;
import io.druid.segment.MMappedIndex;
import io.druid.segment.MetricHolder;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.SegmentUtils;
import io.druid.segment.SimpleQueryableIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ColumnDescriptor;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.ArrayIndexed;
import io.druid.segment.data.BitmapSerde;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferSerializer;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import io.druid.segment.serde.ComplexColumnPartSerde;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import io.druid.segment.serde.FloatGenericColumnPartSerde;
import io.druid.segment.serde.FloatGenericColumnSupplier;
import io.druid.segment.serde.LongGenericColumnPartSerde;
import io.druid.segment.serde.LongGenericColumnSupplier;
import io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.joda.time.Interval;

public class IndexIO {
    public static final byte V8_VERSION = 8;
    public static final byte V9_VERSION = 9;
    public static final int CURRENT_VERSION_ID = 9;
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    private static final Map<Integer, IndexLoader> indexLoaders = ImmutableMap.builder().put((Object)0, (Object)new LegacyIndexLoader()).put((Object)1, (Object)new LegacyIndexLoader()).put((Object)2, (Object)new LegacyIndexLoader()).put((Object)3, (Object)new LegacyIndexLoader()).put((Object)4, (Object)new LegacyIndexLoader()).put((Object)5, (Object)new LegacyIndexLoader()).put((Object)6, (Object)new LegacyIndexLoader()).put((Object)7, (Object)new LegacyIndexLoader()).put((Object)8, (Object)new LegacyIndexLoader()).put((Object)9, (Object)new V9IndexLoader()).build();
    private static final EmittingLogger log = new EmittingLogger(IndexIO.class);
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private static final ObjectMapper mapper;
    private static final BitmapSerdeFactory bitmapSerdeFactory;
    protected static final ColumnConfig columnConfig;

    public static QueryableIndex loadIndex(File inDir) throws IOException {
        int version = SegmentUtils.getVersionFromDir((File)inDir);
        IndexLoader loader = indexLoaders.get(version);
        if (loader != null) {
            return loader.load(inDir);
        }
        throw new ISE("Unknown index version[%s]", new Object[]{version});
    }

    public static int getVersionFromDir(File inDir) throws IOException {
        int version;
        File versionFile = new File(inDir, "version.bin");
        if (versionFile.exists()) {
            return Ints.fromByteArray((byte[])Files.toByteArray((File)versionFile));
        }
        File indexFile = new File(inDir, "index.drd");
        try (FileInputStream in = new FileInputStream(indexFile);){
            version = ((InputStream)in).read();
        }
        return version;
    }

    public static void checkFileSize(File indexFile) throws IOException {
        long fileSize = indexFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException(String.format("File[%s] too large[%s]", indexFile, fileSize));
        }
    }

    public static boolean convertSegment(File toConvert, File converted) throws IOException {
        int version = SegmentUtils.getVersionFromDir((File)toConvert);
        switch (version) {
            case 1: 
            case 2: 
            case 3: {
                log.makeAlert("Attempt to load segment of version <= 3.", new Object[0]).addData("version", (Object)version).emit();
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                log.info("Old version, re-persisting.", new Object[0]);
                IndexMerger.append(Arrays.asList(new QueryableIndexIndexableAdapter(IndexIO.loadIndex(toConvert))), converted);
                return true;
            }
            case 8: {
                DefaultIndexIOHandler.convertV8toV9(toConvert, converted);
                return true;
            }
        }
        log.info("Version[%s], skipping.", new Object[]{version});
        return false;
    }

    public static File makeDimFile(File dir, String dimension) {
        return new File(dir, String.format("dim_%s.drd", dimension));
    }

    public static File makeTimeFile(File dir, ByteOrder order) {
        return new File(dir, String.format("time_%s.drd", order));
    }

    public static File makeMetricFile(File dir, String metricName, ByteOrder order) {
        return new File(dir, String.format("met_%s_%s.drd", metricName, order));
    }

    static {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable<? extends Module>)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                ConfigProvider.bind((Binder)binder, DruidProcessingConfig.class, (Map)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
                binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.processing.bitmap", BitmapSerdeFactory.class);
            }
        }));
        mapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        columnConfig = (ColumnConfig)injector.getInstance(ColumnConfig.class);
        bitmapSerdeFactory = (BitmapSerdeFactory)injector.getInstance(BitmapSerdeFactory.class);
    }

    static class V9IndexLoader
    implements IndexLoader {
        V9IndexLoader() {
        }

        @Override
        public QueryableIndex load(File inDir) throws IOException {
            log.debug("Mapping v9 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            int theVersion = Ints.fromByteArray((byte[])Files.toByteArray((File)new File(inDir, "version.bin")));
            if (theVersion != 9) {
                throw new IllegalArgumentException(String.format("Expected version[9], got[%s]", theVersion));
            }
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            GenericIndexed<String> cols = GenericIndexed.read(indexBuffer, GenericIndexed.stringStrategy);
            GenericIndexed<String> dims = GenericIndexed.read(indexBuffer, GenericIndexed.stringStrategy);
            Interval dataInterval = new Interval(indexBuffer.getLong(), indexBuffer.getLong());
            BitmapSerdeFactory segmentBitmapSerdeFactory = indexBuffer.hasRemaining() ? (BitmapSerdeFactory)mapper.readValue(serializerUtils.readString(indexBuffer), BitmapSerdeFactory.class) : new BitmapSerde.LegacyBitmapSerdeFactory();
            HashMap columns = Maps.newHashMap();
            for (String columnName : cols) {
                columns.put(columnName, this.deserializeColumn(mapper, smooshedFiles.mapFile(columnName)));
            }
            columns.put("__time", this.deserializeColumn(mapper, smooshedFiles.mapFile("__time")));
            SimpleQueryableIndex index = new SimpleQueryableIndex(dataInterval, cols, dims, segmentBitmapSerdeFactory.getBitmapFactory(), columns, smooshedFiles);
            log.debug("Mapped v9 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return index;
        }

        private Column deserializeColumn(ObjectMapper mapper, ByteBuffer byteBuffer) throws IOException {
            ColumnDescriptor serde = (ColumnDescriptor)mapper.readValue(serializerUtils.readString(byteBuffer), ColumnDescriptor.class);
            return serde.read(byteBuffer, columnConfig);
        }
    }

    static class LegacyIndexLoader
    implements IndexLoader {
        private static final IndexIOHandler legacyHandler = new DefaultIndexIOHandler();

        LegacyIndexLoader() {
        }

        @Override
        public QueryableIndex load(File inDir) throws IOException {
            MMappedIndex index = legacyHandler.mapDir(inDir);
            HashMap columns = Maps.newHashMap();
            for (String dimension : index.getAvailableDimensions()) {
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING).setHasMultipleValues(true).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(index.getDimValueLookup(dimension), null, index.getDimColumn(dimension), columnConfig.columnCacheSizeBytes())).setBitmapIndex(new BitmapIndexColumnPartSupplier((BitmapFactory)new ConciseBitmapFactory(), index.getBitmapIndexes().get(dimension), index.getDimValueLookup(dimension)));
                if (index.getSpatialIndexes().get(dimension) != null) {
                    builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(index.getSpatialIndexes().get(dimension)));
                }
                columns.put(dimension, builder.build());
            }
            for (String metric : index.getAvailableMetrics()) {
                MetricHolder metricHolder = index.getMetricHolder(metric);
                if (metricHolder.getType() == MetricHolder.MetricType.FLOAT) {
                    columns.put(metric, new ColumnBuilder().setType(ValueType.FLOAT).setGenericColumn(new FloatGenericColumnSupplier(metricHolder.floatType, BYTE_ORDER)).build());
                    continue;
                }
                if (metricHolder.getType() != MetricHolder.MetricType.COMPLEX) continue;
                columns.put(metric, new ColumnBuilder().setType(ValueType.COMPLEX).setComplexColumn(new ComplexColumnPartSupplier(metricHolder.getTypeName(), (GenericIndexed)metricHolder.complexType)).build());
            }
            TreeSet colSet = Sets.newTreeSet();
            for (String dimension : index.getAvailableDimensions()) {
                colSet.add(dimension);
            }
            for (String metric : index.getAvailableMetrics()) {
                colSet.add(metric);
            }
            String[] cols = colSet.toArray(new String[colSet.size()]);
            columns.put("__time", new ColumnBuilder().setType(ValueType.LONG).setGenericColumn(new LongGenericColumnSupplier(index.timestamps)).build());
            return new SimpleQueryableIndex(index.getDataInterval(), new ArrayIndexed<String>(cols, String.class), index.getAvailableDimensions(), (BitmapFactory)new ConciseBitmapFactory(), columns, index.getFileMapper());
        }
    }

    static interface IndexLoader {
        public QueryableIndex load(File var1) throws IOException;
    }

    public static class DefaultIndexIOHandler
    implements IndexIOHandler {
        private static final Logger log = new Logger(DefaultIndexIOHandler.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MMappedIndex mapDir(File inDir) throws IOException {
            log.debug("Mapping v8 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(inDir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IllegalArgumentException(String.format("Unknown version[%s]", theVersion));
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, (boolean)false);
                throw throwable;
            }
            Closeables.close((Closeable)indexIn, (boolean)false);
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            indexBuffer.get();
            GenericIndexed<String> availableDimensions = GenericIndexed.read(indexBuffer, GenericIndexed.stringStrategy);
            GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.stringStrategy);
            Interval dataInterval = new Interval((Object)serializerUtils.readString(indexBuffer));
            BitmapSerde.LegacyBitmapSerdeFactory bitmapSerdeFactory = new BitmapSerde.LegacyBitmapSerdeFactory();
            CompressedLongsIndexedSupplier timestamps = CompressedLongsIndexedSupplier.fromByteBuffer(smooshedFiles.mapFile(IndexIO.makeTimeFile(inDir, BYTE_ORDER).getName()), BYTE_ORDER);
            LinkedHashMap metrics = Maps.newLinkedHashMap();
            for (String metric : availableMetrics) {
                String metricFilename;
                MetricHolder holder;
                if (!metric.equals((holder = MetricHolder.fromByteBuffer(smooshedFiles.mapFile(metricFilename = IndexIO.makeMetricFile(inDir, metric, BYTE_ORDER).getName()))).getName())) {
                    throw new ISE("Metric[%s] loaded up metric[%s] from disk.  File names do matter.", new Object[]{metric, holder.getName()});
                }
                metrics.put(metric, holder);
            }
            HashMap dimValueLookups = Maps.newHashMap();
            HashMap dimColumns = Maps.newHashMap();
            HashMap bitmaps = Maps.newHashMap();
            for (String dimension : IndexedIterable.create(availableDimensions)) {
                ByteBuffer dimBuffer = smooshedFiles.mapFile(IndexIO.makeDimFile(inDir, dimension).getName());
                String fileDimensionName = serializerUtils.readString(dimBuffer);
                Preconditions.checkState((boolean)dimension.equals(fileDimensionName), (String)"Dimension file[%s] has dimension[%s] in it!?", (Object[])new Object[]{IndexIO.makeDimFile(inDir, dimension), fileDimensionName});
                dimValueLookups.put(dimension, GenericIndexed.read(dimBuffer, GenericIndexed.stringStrategy));
                dimColumns.put(dimension, VSizeIndexed.readFromByteBuffer(dimBuffer));
            }
            ByteBuffer invertedBuffer = smooshedFiles.mapFile("inverted.drd");
            for (int i = 0; i < availableDimensions.size(); ++i) {
                bitmaps.put(serializerUtils.readString(invertedBuffer), GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
            }
            HashMap spatialIndexed = Maps.newHashMap();
            ByteBuffer spatialBuffer = smooshedFiles.mapFile("spatial.drd");
            while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                spatialIndexed.put(serializerUtils.readString(spatialBuffer), ByteBufferSerializer.read(spatialBuffer, new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory())));
            }
            MMappedIndex retVal = new MMappedIndex(availableDimensions, availableMetrics, dataInterval, timestamps, metrics, dimValueLookups, dimColumns, bitmaps, spatialIndexed, smooshedFiles);
            log.debug("Mapped v8 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void convertV8toV9(File v8Dir, File v9Dir) throws IOException {
            log.info("Converting v8[%s] to v9[%s]", new Object[]{v8Dir, v9Dir});
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(v8Dir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IAE("Unknown version[%s]", new Object[]{theVersion});
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, (boolean)false);
                throw throwable;
            }
            Closeables.close((Closeable)indexIn, (boolean)false);
            SmooshedFileMapper v8SmooshedFiles = Smoosh.map((File)v8Dir);
            v9Dir.mkdirs();
            FileSmoosher v9Smoosher = new FileSmoosher(v9Dir);
            ByteStreams.write((byte[])Ints.toByteArray((int)9), (OutputSupplier)Files.newOutputStreamSupplier((File)new File(v9Dir, "version.bin")));
            HashMap bitmapIndexes = Maps.newHashMap();
            ByteBuffer invertedBuffer = v8SmooshedFiles.mapFile("inverted.drd");
            while (invertedBuffer.hasRemaining()) {
                String dimName = serializerUtils.readString(invertedBuffer);
                bitmapIndexes.put(dimName, GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
            }
            HashMap spatialIndexes = Maps.newHashMap();
            ByteBuffer spatialBuffer = v8SmooshedFiles.mapFile("spatial.drd");
            while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                spatialIndexes.put(serializerUtils.readString(spatialBuffer), ByteBufferSerializer.read(spatialBuffer, new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory())));
            }
            LinkedHashSet skippedFiles = Sets.newLinkedHashSet();
            final LinkedHashSet skippedDimensions = Sets.newLinkedHashSet();
            for (String filename : v8SmooshedFiles.getInternalFilenames()) {
                log.info("Processing file[%s]", new Object[]{filename});
                if (filename.startsWith("dim_")) {
                    ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
                    builder.setValueType(ValueType.STRING);
                    ArrayList outParts = Lists.newArrayList();
                    ByteBuffer dimBuffer = v8SmooshedFiles.mapFile(filename);
                    String dimension = serializerUtils.readString(dimBuffer);
                    if (!filename.equals(String.format("dim_%s.drd", dimension))) {
                        throw new ISE("loaded dimension[%s] from file[%s]", new Object[]{dimension, filename});
                    }
                    ByteArrayOutputStream nameBAOS = new ByteArrayOutputStream();
                    serializerUtils.writeString((OutputStream)nameBAOS, dimension);
                    outParts.add(ByteBuffer.wrap(nameBAOS.toByteArray()));
                    GenericIndexed<String> dictionary = GenericIndexed.read(dimBuffer, GenericIndexed.stringStrategy);
                    if (dictionary.size() == 0) {
                        log.info("Dimension[%s] had cardinality 0, equivalent to no column, so skipping.", new Object[]{dimension});
                        skippedDimensions.add(dimension);
                        continue;
                    }
                    VSizeIndexedInts singleValCol = null;
                    VSizeIndexed multiValCol = VSizeIndexed.readFromByteBuffer(dimBuffer.asReadOnlyBuffer());
                    GenericIndexed<ImmutableBitmap> bitmaps = (GenericIndexed<ImmutableBitmap>)bitmapIndexes.get(dimension);
                    ImmutableRTree spatialIndex = (ImmutableRTree)spatialIndexes.get(dimension);
                    BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
                    boolean onlyOneValue = true;
                    MutableBitmap nullsSet = null;
                    for (int i = 0; i < multiValCol.size(); ++i) {
                        VSizeIndexedInts rowValue = multiValCol.get(i);
                        if (!onlyOneValue) break;
                        if (rowValue.size() > 1) {
                            onlyOneValue = false;
                        }
                        if (rowValue.size() != 0) continue;
                        if (nullsSet == null) {
                            nullsSet = bitmapFactory.makeEmptyMutableBitmap();
                        }
                        nullsSet.add(i);
                    }
                    if (onlyOneValue) {
                        boolean bumpedDictionary;
                        log.info("Dimension[%s] is single value, converting...", new Object[]{dimension});
                        if (nullsSet != null) {
                            log.info("Dimension[%s] has null rows.", new Object[]{dimension});
                            ImmutableBitmap theNullSet = bitmapFactory.makeImmutableBitmap(nullsSet);
                            if (dictionary.get(0) != null) {
                                log.info("Dimension[%s] has no null value in the dictionary, expanding...", new Object[]{dimension});
                                bumpedDictionary = true;
                                ArrayList nullList = Lists.newArrayList();
                                nullList.add(null);
                                dictionary = GenericIndexed.fromIterable(Iterables.concat((Iterable)nullList, dictionary), GenericIndexed.stringStrategy);
                                bitmaps = GenericIndexed.fromIterable(Iterables.concat(Arrays.asList(theNullSet), (Iterable)bitmaps), bitmapSerdeFactory.getObjectStrategy());
                            } else {
                                bumpedDictionary = false;
                                bitmaps = GenericIndexed.fromIterable(Iterables.concat(Arrays.asList(bitmapFactory.union(Arrays.asList(theNullSet, (ImmutableBitmap)bitmaps.get(0)))), (Iterable)Iterables.skip((Iterable)bitmaps, (int)1)), bitmapSerdeFactory.getObjectStrategy());
                            }
                        } else {
                            bumpedDictionary = false;
                        }
                        final VSizeIndexed finalMultiValCol = multiValCol;
                        singleValCol = VSizeIndexedInts.fromList((List<Integer>)new AbstractList<Integer>(){

                            @Override
                            public Integer get(int index) {
                                VSizeIndexedInts ints = finalMultiValCol.get(index);
                                return ints.size() == 0 ? 0 : ints.get(0) + (bumpedDictionary ? 1 : 0);
                            }

                            @Override
                            public int size() {
                                return finalMultiValCol.size();
                            }
                        }, dictionary.size());
                        multiValCol = null;
                    } else {
                        builder.setHasMultipleValues(true);
                    }
                    builder.addSerde(new DictionaryEncodedColumnPartSerde(dictionary, singleValCol, multiValCol, bitmapSerdeFactory, bitmaps, spatialIndex));
                    ColumnDescriptor serdeficator = builder.build();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    serializerUtils.writeString((OutputStream)baos, mapper.writeValueAsString((Object)serdeficator));
                    byte[] specBytes = baos.toByteArray();
                    SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(dimension, serdeficator.numBytes() + (long)specBytes.length);
                    channel.write(ByteBuffer.wrap(specBytes));
                    serdeficator.write((WritableByteChannel)channel);
                    channel.close();
                    continue;
                }
                if (filename.startsWith("met_")) {
                    if (!filename.endsWith(String.format("%s.drd", BYTE_ORDER))) {
                        skippedFiles.add(filename);
                        continue;
                    }
                    MetricHolder holder = MetricHolder.fromByteBuffer(v8SmooshedFiles.mapFile(filename));
                    String metric = holder.getName();
                    ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
                    switch (holder.getType()) {
                        case LONG: {
                            builder.setValueType(ValueType.LONG);
                            builder.addSerde(new LongGenericColumnPartSerde(holder.longType, BYTE_ORDER));
                            break;
                        }
                        case FLOAT: {
                            builder.setValueType(ValueType.FLOAT);
                            builder.addSerde(new FloatGenericColumnPartSerde(holder.floatType, BYTE_ORDER));
                            break;
                        }
                        case COMPLEX: {
                            if (!(holder.complexType instanceof GenericIndexed)) {
                                throw new ISE("Serialized complex types must be GenericIndexed objects.", new Object[0]);
                            }
                            GenericIndexed column = (GenericIndexed)holder.complexType;
                            String complexType = holder.getTypeName();
                            builder.setValueType(ValueType.COMPLEX);
                            builder.addSerde(new ComplexColumnPartSerde(column, complexType));
                            break;
                        }
                        default: {
                            throw new ISE("Unknown type[%s]", new Object[]{holder.getType()});
                        }
                    }
                    ColumnDescriptor serdeficator = builder.build();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    serializerUtils.writeString((OutputStream)baos, mapper.writeValueAsString((Object)serdeficator));
                    byte[] specBytes = baos.toByteArray();
                    SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(metric, serdeficator.numBytes() + (long)specBytes.length);
                    channel.write(ByteBuffer.wrap(specBytes));
                    serdeficator.write((WritableByteChannel)channel);
                    channel.close();
                    continue;
                }
                if (String.format("time_%s.drd", BYTE_ORDER).equals(filename)) {
                    CompressedLongsIndexedSupplier timestamps = CompressedLongsIndexedSupplier.fromByteBuffer(v8SmooshedFiles.mapFile(filename), BYTE_ORDER);
                    ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(new LongGenericColumnPartSerde(timestamps, BYTE_ORDER));
                    ColumnDescriptor serdeficator = builder.build();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    serializerUtils.writeString((OutputStream)baos, mapper.writeValueAsString((Object)serdeficator));
                    byte[] specBytes = baos.toByteArray();
                    SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter("__time", serdeficator.numBytes() + (long)specBytes.length);
                    channel.write(ByteBuffer.wrap(specBytes));
                    serdeficator.write((WritableByteChannel)channel);
                    channel.close();
                    continue;
                }
                skippedFiles.add(filename);
            }
            ByteBuffer indexBuffer = v8SmooshedFiles.mapFile("index.drd");
            indexBuffer.get();
            GenericIndexed<String> dims8 = GenericIndexed.read(indexBuffer, GenericIndexed.stringStrategy);
            GenericIndexed<String> dims9 = GenericIndexed.fromIterable(Iterables.filter(dims8, (Predicate)new Predicate<String>(){

                public boolean apply(String s) {
                    return !skippedDimensions.contains(s);
                }
            }), GenericIndexed.stringStrategy);
            GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.stringStrategy);
            Interval dataInterval = new Interval((Object)serializerUtils.readString(indexBuffer));
            BitmapSerdeFactory segmentBitmapSerdeFactory = (BitmapSerdeFactory)mapper.readValue(serializerUtils.readString(indexBuffer), BitmapSerdeFactory.class);
            TreeSet columns = Sets.newTreeSet();
            columns.addAll(Lists.newArrayList(dims9));
            columns.addAll(Lists.newArrayList(availableMetrics));
            GenericIndexed<String> cols = GenericIndexed.fromIterable(columns, GenericIndexed.stringStrategy);
            String segmentBitmapSerdeFactoryString = mapper.writeValueAsString((Object)segmentBitmapSerdeFactory);
            long numBytes = cols.getSerializedSize() + dims9.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(segmentBitmapSerdeFactoryString);
            SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
            cols.writeToChannel((WritableByteChannel)writer);
            dims9.writeToChannel((WritableByteChannel)writer);
            serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getStartMillis());
            serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getEndMillis());
            serializerUtils.writeString((WritableByteChannel)writer, segmentBitmapSerdeFactoryString);
            writer.close();
            log.info("Skipped files[%s]", new Object[]{skippedFiles});
            v9Smoosher.close();
        }
    }

    public static interface IndexIOHandler {
        public MMappedIndex mapDir(File var1) throws IOException;
    }
}

