/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.DimValHolder;
import io.druid.query.topn.DimensionAndMetricValueExtractor;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.query.topn.TopNResultValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class TopNLexicographicResultBuilder
implements TopNResultBuilder {
    private final DateTime timestamp;
    private final DimensionSpec dimSpec;
    private final String previousStop;
    private final Comparator comparator;
    private final List<AggregatorFactory> aggFactories;
    private MinMaxPriorityQueue<DimValHolder> pQueue = null;

    public TopNLexicographicResultBuilder(DateTime timestamp, DimensionSpec dimSpec, int threshold, String previousStop, Comparator comparator, List<AggregatorFactory> aggFactories) {
        this.timestamp = timestamp;
        this.dimSpec = dimSpec;
        this.previousStop = previousStop;
        this.comparator = comparator;
        this.aggFactories = aggFactories;
        this.instantiatePQueue(threshold, comparator);
    }

    @Override
    public TopNResultBuilder addEntry(String dimName, Object dimValIndex, Object[] metricVals) {
        LinkedHashMap metricValues = Maps.newLinkedHashMap();
        if (this.comparator.compare(dimName, this.previousStop) > 0) {
            metricValues.put(this.dimSpec.getOutputName(), dimName);
            Iterator<AggregatorFactory> aggsIter = this.aggFactories.iterator();
            for (Object metricVal : metricVals) {
                metricValues.put(aggsIter.next().getName(), metricVal);
            }
            this.pQueue.add((Object)new DimValHolder.Builder().withDirName(dimName).withMetricValues(metricValues).build());
        }
        return this;
    }

    @Override
    public TopNResultBuilder addEntry(DimensionAndMetricValueExtractor dimensionAndMetricValueExtractor) {
        this.pQueue.add((Object)new DimValHolder.Builder().withDirName(dimensionAndMetricValueExtractor.getStringDimensionValue(this.dimSpec.getOutputName())).withMetricValues(dimensionAndMetricValueExtractor.getBaseObject()).build());
        return this;
    }

    @Override
    public Iterator<DimValHolder> getTopNIterator() {
        return this.pQueue.iterator();
    }

    @Override
    public Result<TopNResultValue> build() {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(this.pQueue.size());
        while (!this.pQueue.isEmpty()) {
            values.add(((DimValHolder)this.pQueue.remove()).getMetricValues());
        }
        return new Result<TopNResultValue>(this.timestamp, new TopNResultValue(values));
    }

    private void instantiatePQueue(int threshold, final Comparator comparator) {
        this.pQueue = MinMaxPriorityQueue.orderedBy((Comparator)new Comparator<DimValHolder>(){

            @Override
            public int compare(DimValHolder o1, DimValHolder o2) {
                return comparator.compare(o1.getDimName(), o2.getDimName());
            }
        }).maximumSize(threshold).create();
    }
}

