/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.Result;
import io.druid.query.filter.DimFilter;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectResultValue;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;

@JsonTypeName(value="select")
public class SelectQuery
extends BaseQuery<Result<SelectResultValue>> {
    private final DimFilter dimFilter;
    private final QueryGranularity granularity;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final PagingSpec pagingSpec;

    @JsonCreator
    public SelectQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JsonProperty(value="pagingSpec") PagingSpec pagingSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context);
        this.dimFilter = dimFilter;
        this.granularity = granularity;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.pagingSpec = pagingSpec;
        Preconditions.checkNotNull((Object)pagingSpec, (Object)"must specify a pagingSpec");
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "select";
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public PagingSpec getPagingSpec() {
        return this.pagingSpec;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    public SelectQuery withQuerySegmentSpec(QuerySegmentSpec querySegmentSpec) {
        return new SelectQuery(this.getDataSource(), querySegmentSpec, this.dimFilter, this.granularity, this.dimensions, this.metrics, this.pagingSpec, this.getContext());
    }

    @Override
    public Query<Result<SelectResultValue>> withDataSource(DataSource dataSource) {
        return new SelectQuery(dataSource, this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.metrics, this.pagingSpec, this.getContext());
    }

    public SelectQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return new SelectQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.dimFilter, this.granularity, this.dimensions, this.metrics, this.pagingSpec, this.computeOverridenContext(contextOverrides));
    }

    public String toString() {
        return "SelectQuery{dataSource='" + this.getDataSource() + '\'' + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", dimFilter=" + this.dimFilter + ", granularity=" + this.granularity + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", pagingSpec=" + this.pagingSpec + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectQuery that = (SelectQuery)o;
        if (this.dimFilter != null ? !this.dimFilter.equals(that.dimFilter) : that.dimFilter != null) {
            return false;
        }
        if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(that.granularity) : that.granularity != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        return !(this.pagingSpec != null ? !this.pagingSpec.equals(that.pagingSpec) : that.pagingSpec != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.metrics != null ? this.metrics.hashCode() : 0);
        result = 31 * result + (this.pagingSpec != null ? this.pagingSpec.hashCode() : 0);
        return result;
    }
}

