/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.TableDataSource;
import io.druid.query.metadata.metadata.AllColumnIncluderator;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Map;

public class SegmentMetadataQuery
extends BaseQuery<SegmentAnalysis> {
    private final ColumnIncluderator toInclude;
    private final boolean merge;

    @JsonCreator
    public SegmentMetadataQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="toInclude") ColumnIncluderator toInclude, @JsonProperty(value="merge") Boolean merge, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, context);
        this.toInclude = toInclude == null ? new AllColumnIncluderator() : toInclude;
        this.merge = merge == null ? false : merge;
        Preconditions.checkArgument((boolean)(dataSource instanceof TableDataSource), (Object)"SegmentMetadataQuery only supports table datasource");
    }

    @JsonProperty
    public ColumnIncluderator getToInclude() {
        return this.toInclude;
    }

    @JsonProperty
    public boolean isMerge() {
        return this.merge;
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public String getType() {
        return "segmentMetadata";
    }

    @Override
    public Query<SegmentAnalysis> withOverriddenContext(Map<String, Object> contextOverride) {
        return new SegmentMetadataQuery(this.getDataSource(), this.getQuerySegmentSpec(), this.toInclude, this.merge, this.computeOverridenContext(contextOverride));
    }

    @Override
    public Query<SegmentAnalysis> withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new SegmentMetadataQuery(this.getDataSource(), spec, this.toInclude, this.merge, this.getContext());
    }

    @Override
    public Query<SegmentAnalysis> withDataSource(DataSource dataSource) {
        return new SegmentMetadataQuery(dataSource, this.getQuerySegmentSpec(), this.toInclude, this.merge, this.getContext());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SegmentMetadataQuery that = (SegmentMetadataQuery)o;
        if (this.merge != that.merge) {
            return false;
        }
        return !(this.toInclude != null ? !this.toInclude.equals(that.toInclude) : that.toInclude != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.toInclude != null ? this.toInclude.hashCode() : 0);
        result = 31 * result + (this.merge ? 1 : 0);
        return result;
    }
}

