/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class SelectorDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;

    @JsonCreator
    public SelectorDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        this.dimension = dimension;
        this.value = value;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] valueBytes = this.value == null ? new byte[]{} : StringUtils.toUtf8((String)this.value);
        return ByteBuffer.allocate(1 + dimensionBytes.length + valueBytes.length).put((byte)0).put(dimensionBytes).put(valueBytes).array();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorDimFilter that = (SelectorDimFilter)o;
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s = %s", this.dimension, this.value);
    }
}

